/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.metadata;

import java.util.Optional;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.common.document.DocumentField;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.Index;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.metadata.MetadataIndex;
import org.sonar.server.es.metadata.MetadataIndexDefinition;
import org.sonar.server.es.newindex.DefaultIndexSettings;

public class MetadataIndexImpl
implements MetadataIndex {
    private static final String DB_VENDOR_KEY = "dbVendor";
    private final EsClient esClient;

    public MetadataIndexImpl(EsClient esClient) {
        this.esClient = esClient;
    }

    @Override
    public Optional<String> getHash(Index index) {
        return this.getMetadata(MetadataIndexImpl.hashId(index));
    }

    @Override
    public void setHash(Index index, String hash) {
        this.setMetadata(MetadataIndexImpl.hashId(index), hash);
    }

    private static String hashId(Index index) {
        return index.getName() + ".indexStructure";
    }

    @Override
    public boolean getInitialized(IndexType indexType) {
        return this.getMetadata(MetadataIndexImpl.initializedId(indexType)).map(Boolean::parseBoolean).orElse(false);
    }

    @Override
    public void setInitialized(IndexType indexType, boolean initialized) {
        this.setMetadata(MetadataIndexImpl.initializedId(indexType), String.valueOf(initialized));
    }

    private static String initializedId(IndexType indexType) {
        if (indexType instanceof IndexType.IndexMainType) {
            IndexType.IndexMainType mainType = (IndexType.IndexMainType)indexType;
            return mainType.getIndex().getName() + "." + mainType.getType() + ".initialized";
        }
        if (indexType instanceof IndexType.IndexRelationType) {
            IndexType.IndexRelationType relationType = (IndexType.IndexRelationType)indexType;
            IndexType.IndexMainType mainType = relationType.getMainType();
            return mainType.getIndex().getName() + "." + mainType.getType() + "." + relationType.getName() + ".initialized";
        }
        throw new IllegalArgumentException("Unsupported IndexType " + indexType.getClass());
    }

    @Override
    public Optional<String> getDbVendor() {
        return this.getMetadata(DB_VENDOR_KEY);
    }

    @Override
    public void setDbMetadata(String vendor) {
        this.setMetadata(DB_VENDOR_KEY, vendor);
    }

    private Optional<String> getMetadata(String id) {
        GetRequestBuilder request = this.esClient.prepareGet(MetadataIndexDefinition.TYPE_METADATA, id).setStoredFields(new String[]{"value"});
        GetResponse response = (GetResponse)request.get();
        if (response.isExists()) {
            DocumentField field = response.getField("value");
            return Optional.of((String)field.getValue());
        }
        return Optional.empty();
    }

    private void setMetadata(String id, String value) {
        ((IndexRequestBuilder)this.esClient.prepareIndex(MetadataIndexDefinition.TYPE_METADATA).setId(id).setSource(new Object[]{"value", value}).setRefreshPolicy(DefaultIndexSettings.REFRESH_IMMEDIATE)).get();
    }
}

