/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyClearCacheRequestBuilder
extends ClearIndicesCacheRequestBuilder {
    public ProxyClearCacheRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().indices(), ClearIndicesCacheAction.INSTANCE);
    }

    public ClearIndicesCacheResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            ClearIndicesCacheResponse clearIndicesCacheResponse = (ClearIndicesCacheResponse)super.execute().actionGet();
            return clearIndicesCacheResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public ClearIndicesCacheResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ClearIndicesCacheResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<ClearIndicesCacheResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        Object[] fields;
        StringBuilder message = new StringBuilder();
        message.append("ES clear cache request");
        if (((ClearIndicesCacheRequest)this.request).indices().length > 0) {
            message.append(String.format(" on indices '%s'", StringUtils.join((Object[])((ClearIndicesCacheRequest)this.request).indices(), (String)",")));
        }
        if ((fields = ((ClearIndicesCacheRequest)this.request).fields()) != null && fields.length > 0) {
            message.append(String.format(" on fields '%s'", StringUtils.join((Object[])fields, (String)",")));
        }
        if (((ClearIndicesCacheRequest)this.request).queryCache()) {
            message.append(" with filter cache");
        }
        if (((ClearIndicesCacheRequest)this.request).fieldDataCache()) {
            message.append(" with field data cache");
        }
        if (((ClearIndicesCacheRequest)this.request).requestCache()) {
            message.append(" with request cache");
        }
        return message.toString();
    }
}

