/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import java.io.IOException;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyCreateIndexRequestBuilder
extends CreateIndexRequestBuilder {
    private final String index;

    public ProxyCreateIndexRequestBuilder(Client client, String index) {
        super((ElasticsearchClient)client.admin().indices(), CreateIndexAction.INSTANCE, index);
        this.index = index;
    }

    public CreateIndexResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            CreateIndexResponse createIndexResponse = (CreateIndexResponse)super.execute().actionGet();
            return createIndexResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public CreateIndexResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public CreateIndexResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<CreateIndexResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toJson() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject().field("settings").startObject();
            ((CreateIndexRequest)this.request).settings().toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.endObject().endObject();
            builder.prettyPrint();
            return builder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return String.format("ES create index '%s'", this.index);
    }
}

