/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.es.request;

import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.ListenableActionFuture;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsAction;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestBuilder;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.unit.TimeValue;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Profiler;
import org.sonar.server.es.EsClient;

public class ProxyNodesStatsRequestBuilder
extends NodesStatsRequestBuilder {
    public ProxyNodesStatsRequestBuilder(Client client) {
        super((ElasticsearchClient)client.admin().cluster(), NodesStatsAction.INSTANCE);
    }

    public NodesStatsResponse get() {
        Profiler profiler = Profiler.createIfTrace((Logger)EsClient.LOGGER).start();
        try {
            NodesStatsResponse nodesStatsResponse = (NodesStatsResponse)super.execute().actionGet();
            return nodesStatsResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Fail to execute %s", this.toString()), e);
        }
        finally {
            if (profiler.isTraceEnabled()) {
                profiler.stopTrace(this.toString());
            }
        }
    }

    public NodesStatsResponse get(TimeValue timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public NodesStatsResponse get(String timeout) {
        throw new IllegalStateException("Not yet implemented");
    }

    public ListenableActionFuture<NodesStatsResponse> execute() {
        throw new UnsupportedOperationException("execute() should not be called as it's used for asynchronous");
    }

    public String toString() {
        StringBuilder message = new StringBuilder();
        message.append("ES nodes stats request");
        if (((NodesStatsRequest)this.request).nodesIds().length > 0) {
            message.append(String.format(" on nodes '%s'", StringUtils.join((Object[])((NodesStatsRequest)this.request).nodesIds(), (String)",")));
        }
        return message.toString();
    }
}

