/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue;

import org.sonar.core.issue.DefaultIssue;
import org.sonar.core.issue.DefaultIssueComment;
import org.sonar.core.issue.FieldDiffs;
import org.sonar.db.issue.IssueChangeDto;
import org.sonar.db.issue.IssueChangeMapper;

public class IssueStorage {
    public void insertChanges(IssueChangeMapper mapper, DefaultIssue issue) {
        for (Object comment : issue.defaultIssueComments()) {
            if (!comment.isNew()) continue;
            IssueChangeDto changeDto = IssueChangeDto.of((DefaultIssueComment)comment);
            mapper.insert(changeDto);
        }
        FieldDiffs diffs = issue.currentChange();
        if (issue.isCopied()) {
            for (FieldDiffs d : issue.changes()) {
                IssueChangeDto changeDto = IssueChangeDto.of((String)issue.key(), (FieldDiffs)d);
                mapper.insert(changeDto);
            }
        } else if (!issue.isNew() && diffs != null) {
            IssueChangeDto changeDto = IssueChangeDto.of((String)issue.key(), (FieldDiffs)diffs);
            mapper.insert(changeDto);
        }
    }
}

