/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Objects;
import org.sonar.api.notifications.Notification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

class FPOrWontFixNotification
extends Notification {
    private static final String KEY = "FPorWontFix";
    private final IssuesChangesNotificationBuilder.Change change;
    private final SetMultimap<IssuesChangesNotificationBuilder.Project, IssuesChangesNotificationBuilder.ChangedIssue> changedIssues;
    private final FpOrWontFix resolution;

    public FPOrWontFixNotification(IssuesChangesNotificationBuilder.Change change, Collection<IssuesChangesNotificationBuilder.ChangedIssue> changedIssues, FpOrWontFix resolution) {
        super(KEY);
        this.changedIssues = (SetMultimap)changedIssues.stream().collect(MoreCollectors.unorderedIndex(IssuesChangesNotificationBuilder.ChangedIssue::getProject, t -> t));
        this.change = change;
        this.resolution = resolution;
    }

    public IssuesChangesNotificationBuilder.Change getChange() {
        return this.change;
    }

    public SetMultimap<IssuesChangesNotificationBuilder.Project, IssuesChangesNotificationBuilder.ChangedIssue> getChangedIssues() {
        return this.changedIssues;
    }

    public FpOrWontFix getResolution() {
        return this.resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FPOrWontFixNotification that = (FPOrWontFixNotification)((Object)o);
        return Objects.equals(this.changedIssues, that.changedIssues) && Objects.equals(this.change, that.change) && this.resolution == that.resolution;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changedIssues, this.change, this.resolution});
    }

    public String toString() {
        return "FPOrWontFixNotification{changedIssues=" + this.changedIssues + ", change=" + this.change + ", resolution=" + (Object)((Object)this.resolution) + '}';
    }

    public static enum FpOrWontFix {
        FP,
        WONT_FIX;

    }
}

