/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.SortedSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.sonar.api.config.EmailSettings;
import org.sonar.core.i18n.I18n;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.EmailTemplate;
import org.sonar.server.issue.notification.IssuesChangesNotificationBuilder;

public abstract class IssueChangesEmailTemplate
implements EmailTemplate {
    private static final Comparator<IssuesChangesNotificationBuilder.Rule> RULE_COMPARATOR = Comparator.comparing(r -> r.getKey().toString());
    private static final Comparator<IssuesChangesNotificationBuilder.Project> PROJECT_COMPARATOR = Comparator.comparing(IssuesChangesNotificationBuilder.Project::getProjectName).thenComparing(t -> t.getBranchName().orElse(""));
    private static final Comparator<IssuesChangesNotificationBuilder.ChangedIssue> CHANGED_ISSUE_KEY_COMPARATOR = Comparator.comparing(IssuesChangesNotificationBuilder.ChangedIssue::getKey, Comparator.naturalOrder());
    private static final int MAX_ISSUES_BY_LINK = 40;
    private static final String URL_ENCODED_COMMA = IssueChangesEmailTemplate.urlEncode(",");
    private final I18n i18n;
    private final EmailSettings settings;

    protected IssueChangesEmailTemplate(I18n i18n, EmailSettings settings) {
        this.i18n = i18n;
        this.settings = settings;
    }

    protected static void toString(StringBuilder sb, IssuesChangesNotificationBuilder.Project project) {
        Optional<String> branchName = project.getBranchName();
        if (branchName.isPresent()) {
            sb.append(project.getProjectName()).append(", ").append(branchName.get());
        } else {
            sb.append(project.getProjectName());
        }
    }

    static String toUrlParams(IssuesChangesNotificationBuilder.Project project) {
        return "id=" + IssueChangesEmailTemplate.urlEncode(project.getKey()) + project.getBranchName().map(branchName -> "&branch=" + IssueChangesEmailTemplate.urlEncode(branchName)).orElse("");
    }

    void addIssuesByProjectThenRule(StringBuilder sb, SetMultimap<IssuesChangesNotificationBuilder.Project, IssuesChangesNotificationBuilder.ChangedIssue> issuesByProject) {
        issuesByProject.keySet().stream().sorted(PROJECT_COMPARATOR).forEach(project -> {
            String encodedProjectParams = IssueChangesEmailTemplate.toUrlParams(project);
            IssueChangesEmailTemplate.paragraph(sb, s -> IssueChangesEmailTemplate.toString(s, project));
            this.addIssuesByRule(sb, issuesByProject.get(project), this.projectIssuePageHref(encodedProjectParams));
        });
    }

    void addIssuesByRule(StringBuilder sb, Collection<IssuesChangesNotificationBuilder.ChangedIssue> changedIssues, BiConsumer<StringBuilder, Collection<IssuesChangesNotificationBuilder.ChangedIssue>> issuePageHref) {
        ListMultimap issuesByRule = (ListMultimap)changedIssues.stream().collect(MoreCollectors.index(IssuesChangesNotificationBuilder.ChangedIssue::getRule, t -> t));
        Iterator rules = issuesByRule.keySet().stream().sorted(RULE_COMPARATOR).iterator();
        if (!rules.hasNext()) {
            return;
        }
        sb.append("<ul>");
        while (rules.hasNext()) {
            IssuesChangesNotificationBuilder.Rule rule = (IssuesChangesNotificationBuilder.Rule)rules.next();
            List issues = issuesByRule.get((Object)rule);
            sb.append("<li>").append("Rule ").append(" <em>").append(rule.getName()).append("</em> - ");
            IssueChangesEmailTemplate.appendIssueLinks(sb, issuePageHref, issues);
            sb.append("</li>");
        }
        sb.append("</ul>");
    }

    private static void appendIssueLinks(StringBuilder sb, BiConsumer<StringBuilder, Collection<IssuesChangesNotificationBuilder.ChangedIssue>> issuePageHref, Collection<IssuesChangesNotificationBuilder.ChangedIssue> issues) {
        ImmutableSortedSet sortedIssues = ImmutableSortedSet.copyOf(CHANGED_ISSUE_KEY_COMPARATOR, issues);
        int issueCount = issues.size();
        if (issueCount == 1) {
            IssueChangesEmailTemplate.link(sb, arg_0 -> IssueChangesEmailTemplate.lambda$appendIssueLinks$6(issuePageHref, (SortedSet)sortedIssues, arg_0), s -> s.append("See the single issue"));
        } else if (issueCount <= 40) {
            IssueChangesEmailTemplate.link(sb, arg_0 -> IssueChangesEmailTemplate.lambda$appendIssueLinks$8(issuePageHref, (SortedSet)sortedIssues, arg_0), s -> s.append("See all ").append(issueCount).append(" issues"));
        } else {
            sb.append("See issues");
            List issueGroups = Lists.partition((List)ImmutableList.copyOf((Collection)sortedIssues), (int)40);
            Iterator issueGroupsIterator = issueGroups.iterator();
            int[] groupIndex = new int[]{0};
            while (issueGroupsIterator.hasNext()) {
                List issueGroup = (List)issueGroupsIterator.next();
                sb.append(' ');
                IssueChangesEmailTemplate.link(sb, s -> issuePageHref.accept((StringBuilder)s, issueGroup), IssueChangesEmailTemplate.issueGroupLabel(sb, groupIndex, issueGroup));
                groupIndex[0] = groupIndex[0] + 1;
            }
        }
    }

    BiConsumer<StringBuilder, Collection<IssuesChangesNotificationBuilder.ChangedIssue>> projectIssuePageHref(String projectParams) {
        return (s, issues) -> {
            s.append(this.settings.getServerBaseURL()).append("/project/issues?").append(projectParams).append("&issues=");
            Iterator issueIterator = issues.iterator();
            while (issueIterator.hasNext()) {
                s.append(IssueChangesEmailTemplate.urlEncode(((IssuesChangesNotificationBuilder.ChangedIssue)issueIterator.next()).getKey()));
                if (!issueIterator.hasNext()) continue;
                s.append(URL_ENCODED_COMMA);
            }
            if (issues.size() == 1) {
                s.append("&open=").append(IssueChangesEmailTemplate.urlEncode(((IssuesChangesNotificationBuilder.ChangedIssue)issues.iterator().next()).getKey()));
            }
        };
    }

    private static Consumer<StringBuilder> issueGroupLabel(StringBuilder sb, int[] groupIndex, List<IssuesChangesNotificationBuilder.ChangedIssue> issueGroup) {
        return s -> {
            int firstIssueNumber = groupIndex[0] * 40 + 1;
            if (issueGroup.size() == 1) {
                sb.append(firstIssueNumber);
            } else {
                sb.append(firstIssueNumber).append("-").append(firstIssueNumber + issueGroup.size() - 1);
            }
        };
    }

    void addFooter(StringBuilder sb, String notificationI18nKey) {
        IssueChangesEmailTemplate.paragraph(sb, s -> s.append("&nbsp;"));
        IssueChangesEmailTemplate.paragraph(sb, s -> {
            s.append("<small>");
            s.append("You received this email because you are subscribed to ").append('\"').append(this.i18n.message(Locale.ENGLISH, notificationI18nKey, notificationI18nKey, new Object[0])).append('\"').append(" notifications from ").append(this.settings.getInstanceName()).append(".");
            s.append(" Click ");
            IssueChangesEmailTemplate.link(s, s1 -> s1.append(this.settings.getServerBaseURL()).append("/account/notifications"), s1 -> s1.append("here"));
            s.append(" to edit your email preferences.");
            s.append("</small>");
        });
    }

    protected static void paragraph(StringBuilder sb, Consumer<StringBuilder> content) {
        sb.append("<p>");
        content.accept(sb);
        sb.append("</p>");
    }

    protected static void link(StringBuilder sb, Consumer<StringBuilder> link, Consumer<StringBuilder> content) {
        sb.append("<a href=\"");
        link.accept(sb);
        sb.append("\">");
        content.accept(sb);
        sb.append("</a>");
    }

    private static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static /* synthetic */ void lambda$appendIssueLinks$8(BiConsumer issuePageHref, SortedSet sortedIssues, StringBuilder s) {
        issuePageHref.accept(s, sortedIssues);
    }

    private static /* synthetic */ void lambda$appendIssueLinks$6(BiConsumer issuePageHref, SortedSet sortedIssues, StringBuilder s) {
        issuePageHref.accept(s, sortedIssues);
    }
}

