/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.rule.RuleKey;

@Immutable
public class IssuesChangesNotificationBuilder {
    private static final String KEY_CANT_BE_NULL_MESSAGE = "key can't be null";
    private final Set<ChangedIssue> issues;
    private final Change change;

    public IssuesChangesNotificationBuilder(Set<ChangedIssue> issues, Change change) {
        Preconditions.checkArgument((!issues.isEmpty() ? 1 : 0) != 0, (Object)"issues can't be empty");
        this.issues = ImmutableSet.copyOf(issues);
        this.change = Objects.requireNonNull(change, "change can't be null");
    }

    public Set<ChangedIssue> getIssues() {
        return this.issues;
    }

    public Change getChange() {
        return this.change;
    }

    @Immutable
    public static final class UserChange
    extends Change {
        private final User user;

        public UserChange(long date, User user) {
            super(date);
            this.user = Objects.requireNonNull(user, "user can't be null");
        }

        public User getUser() {
            return this.user;
        }

        @Override
        public boolean isAuthorLogin(String login) {
            return this.user.login.equals(login);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserChange that = (UserChange)o;
            return this.date == that.date && this.user.equals(that.user);
        }

        public int hashCode() {
            return Objects.hash(this.user, this.date);
        }

        public String toString() {
            return "UserChange{date=" + this.date + ", user=" + this.user + '}';
        }
    }

    @Immutable
    public static final class AnalysisChange
    extends Change {
        public AnalysisChange(long date) {
            super(date);
        }

        @Override
        public boolean isAuthorLogin(String login) {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Change change = (Change)o;
            return this.date == change.date;
        }

        public int hashCode() {
            return Objects.hash(this.date);
        }

        public String toString() {
            return "AnalysisChange{" + this.date + '}';
        }
    }

    public static abstract class Change {
        protected final long date;

        private Change(long date) {
            this.date = Objects.requireNonNull(Long.valueOf(date), "date can't be null");
        }

        public long getDate() {
            return this.date;
        }

        public abstract boolean isAuthorLogin(String var1);
    }

    @Immutable
    public static final class Project {
        private final String uuid;
        private final String key;
        private final String projectName;
        @Nullable
        private final String branchName;

        public Project(Builder builder) {
            this.uuid = Objects.requireNonNull(builder.uuid, "uuid can't be null");
            this.key = Objects.requireNonNull(builder.key, IssuesChangesNotificationBuilder.KEY_CANT_BE_NULL_MESSAGE);
            this.projectName = Objects.requireNonNull(builder.projectName, "projectName can't be null");
            this.branchName = builder.branchName;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getKey() {
            return this.key;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public Optional<String> getBranchName() {
            return Optional.ofNullable(this.branchName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Project project = (Project)o;
            return this.uuid.equals(project.uuid) && this.key.equals(project.key) && this.projectName.equals(project.projectName) && Objects.equals(this.branchName, project.branchName);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.key, this.projectName, this.branchName);
        }

        public String toString() {
            return "Project{uuid='" + this.uuid + '\'' + ", key='" + this.key + '\'' + ", projectName='" + this.projectName + '\'' + ", branchName='" + this.branchName + '\'' + '}';
        }

        public static class Builder {
            private final String uuid;
            private String key;
            private String projectName;
            @CheckForNull
            private String branchName;

            public Builder(String uuid) {
                this.uuid = uuid;
            }

            public Builder setKey(String key) {
                this.key = key;
                return this;
            }

            public Builder setProjectName(String projectName) {
                this.projectName = projectName;
                return this;
            }

            public Builder setBranchName(@Nullable String branchName) {
                this.branchName = branchName;
                return this;
            }

            public Project build() {
                return new Project(this);
            }
        }
    }

    @Immutable
    public static final class Rule {
        private final RuleKey key;
        private final String name;

        public Rule(RuleKey key, String name) {
            this.key = Objects.requireNonNull(key, IssuesChangesNotificationBuilder.KEY_CANT_BE_NULL_MESSAGE);
            this.name = Objects.requireNonNull(name, "name can't be null");
        }

        public RuleKey getKey() {
            return this.key;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule that = (Rule)o;
            return this.key.equals((Object)that.key) && this.name.equals(that.name);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.name);
        }

        public String toString() {
            return "Rule{key=" + this.key + ", name='" + this.name + '\'' + '}';
        }
    }

    public static final class User {
        private final String uuid;
        private final String login;
        @CheckForNull
        private final String name;

        public User(String uuid, String login, @Nullable String name) {
            this.uuid = Objects.requireNonNull(uuid, "uuid can't be null");
            this.login = Objects.requireNonNull(login, "login can't be null");
            this.name = name;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getLogin() {
            return this.login;
        }

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public String toString() {
            return "User{uuid='" + this.uuid + '\'' + ", login='" + this.login + '\'' + ", name='" + this.name + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            User user = (User)o;
            return this.uuid.equals(user.uuid) && this.login.equals(user.login) && Objects.equals(this.name, user.name);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.login, this.name);
        }
    }

    @Immutable
    public static final class ChangedIssue {
        private final String key;
        private final String newStatus;
        @CheckForNull
        private final String newResolution;
        @CheckForNull
        private final User assignee;
        private final Rule rule;
        private final Project project;

        public ChangedIssue(Builder builder) {
            this.key = Objects.requireNonNull(builder.key, IssuesChangesNotificationBuilder.KEY_CANT_BE_NULL_MESSAGE);
            this.newStatus = Objects.requireNonNull(builder.newStatus, "newStatus can't be null");
            this.newResolution = builder.newResolution;
            this.assignee = builder.assignee;
            this.rule = Objects.requireNonNull(builder.rule, "rule can't be null");
            this.project = Objects.requireNonNull(builder.project, "project can't be null");
        }

        public String getKey() {
            return this.key;
        }

        public String getNewStatus() {
            return this.newStatus;
        }

        public Optional<String> getNewResolution() {
            return Optional.ofNullable(this.newResolution);
        }

        public Optional<User> getAssignee() {
            return Optional.ofNullable(this.assignee);
        }

        public Rule getRule() {
            return this.rule;
        }

        public Project getProject() {
            return this.project;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangedIssue that = (ChangedIssue)o;
            return this.key.equals(that.key) && this.newStatus.equals(that.newStatus) && Objects.equals(this.newResolution, that.newResolution) && Objects.equals(this.assignee, that.assignee) && this.rule.equals(that.rule) && this.project.equals(that.project);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.newStatus, this.newResolution, this.assignee, this.rule, this.project);
        }

        public String toString() {
            return "ChangedIssue{key='" + this.key + '\'' + ", newStatus='" + this.newStatus + '\'' + ", newResolution='" + this.newResolution + '\'' + ", assignee=" + this.assignee + ", rule=" + this.rule + ", project=" + this.project + '}';
        }

        public static class Builder {
            private final String key;
            private String newStatus;
            @CheckForNull
            private String newResolution;
            @CheckForNull
            private User assignee;
            private Rule rule;
            private Project project;

            public Builder(String key) {
                this.key = key;
            }

            public Builder setNewStatus(String newStatus) {
                this.newStatus = newStatus;
                return this;
            }

            public Builder setNewResolution(@Nullable String newResolution) {
                this.newResolution = newResolution;
                return this;
            }

            public Builder setAssignee(@Nullable User assignee) {
                this.assignee = assignee;
                return this;
            }

            public Builder setRule(Rule rule) {
                this.rule = rule;
                return this;
            }

            public Builder setProject(Project project) {
                this.project = project;
                return this;
            }

            public ChangedIssue build() {
                return new ChangedIssue(this);
            }
        }
    }
}

