/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.notifications.Notification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.issue.notification.NewIssuesNotification;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;

public class NewIssuesNotificationHandler
extends EmailNotificationHandler<NewIssuesNotification> {
    public static final String KEY = "NewIssues";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create("NewIssues").setProperty("globalNotification", String.valueOf(false)).setProperty("perProjectNotification", String.valueOf(true));
    private final NotificationManager notificationManager;

    public NewIssuesNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
    }

    @Override
    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    @Override
    public Class<NewIssuesNotification> getNotificationClass() {
        return NewIssuesNotification.class;
    }

    @Override
    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<NewIssuesNotification> notifications) {
        Multimap notificationsByProjectKey = (Multimap)notifications.stream().filter(t -> t.getProjectKey() != null).collect(MoreCollectors.index(NewIssuesNotification::getProjectKey));
        if (notificationsByProjectKey.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)notificationsByProjectKey.asMap().entrySet().stream().flatMap(e -> this.toEmailDeliveryRequests((String)e.getKey(), (Collection)e.getValue())).collect(MoreCollectors.toSet((int)notifications.size()));
    }

    private Stream<? extends EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(String projectKey, Collection<NewIssuesNotification> notifications) {
        return this.notificationManager.findSubscribedEmailRecipients(KEY, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER).stream().flatMap(emailRecipient -> notifications.stream().map(notification -> new EmailNotificationChannel.EmailDeliveryRequest(emailRecipient.getEmail(), (Notification)notification)));
    }
}

