/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.issue.workflow;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import org.sonar.api.issue.Issue;
import org.sonar.server.issue.workflow.Transition;

public class State {
    private final String key;
    private final Transition[] outTransitions;

    public State(String key, Transition[] outTransitions) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"State key must be set");
        State.checkDuplications(outTransitions, key);
        this.key = key;
        this.outTransitions = outTransitions;
    }

    private static void checkDuplications(Transition[] transitions, String stateKey) {
        HashSet keys = new HashSet();
        Arrays.stream(transitions).filter(transition -> !keys.add(transition.key())).findAny().ifPresent(transition -> {
            throw new IllegalArgumentException("Transition '" + transition.key() + "' is declared several times from the originating state '" + stateKey + "'");
        });
    }

    public List<Transition> outManualTransitions(Issue issue) {
        return Arrays.stream(this.outTransitions).filter(transition -> !transition.automatic()).filter(transition -> transition.supports(issue)).collect(Collectors.toList());
    }

    @CheckForNull
    public Transition outAutomaticTransition(Issue issue) {
        Transition[] result = new Transition[1];
        HashSet keys = new HashSet();
        Arrays.stream(this.outTransitions).filter(Transition::automatic).filter(transition -> transition.supports(issue)).peek(transition -> {
            result[0] = transition;
        }).filter(transition -> !keys.add(transition.key())).findAny().ifPresent(transition -> {
            throw new IllegalArgumentException("Several automatic transitions are available for issue: " + issue);
        });
        return result[0];
    }

    Transition transition(String transitionKey) {
        return Arrays.stream(this.outTransitions).filter(transition -> transitionKey.equals(transition.key())).findAny().orElseThrow(() -> new IllegalArgumentException("Transition from state " + this.key + " does not exist: " + transitionKey));
    }
}

