/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.index;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.measure.index.ProjectMeasuresIndexDefinition;
import org.sonar.server.permission.index.AuthorizationDoc;

public class ProjectMeasuresDoc
extends BaseDoc {
    public static final Map<String, Integer> QUALITY_GATE_STATUS = ImmutableMap.of((Object)Metric.Level.OK.name(), (Object)1, (Object)Metric.Level.WARN.name(), (Object)2, (Object)Metric.Level.ERROR.name(), (Object)3);

    public ProjectMeasuresDoc() {
        super(ProjectMeasuresIndexDefinition.TYPE_PROJECT_MEASURES, new HashMap<String, Object>(8));
    }

    @Override
    public String getId() {
        return (String)this.getField("uuid");
    }

    public ProjectMeasuresDoc setId(String s) {
        this.setField("uuid", s);
        this.setParent(AuthorizationDoc.idOf(s));
        return this;
    }

    public String getOrganizationUuid() {
        return (String)this.getField("organizationUuid");
    }

    public ProjectMeasuresDoc setOrganizationUuid(String s) {
        this.setField("organizationUuid", s);
        return this;
    }

    public String getKey() {
        return (String)this.getField("key");
    }

    public ProjectMeasuresDoc setKey(String s) {
        this.setField("key", s);
        return this;
    }

    public String getName() {
        return (String)this.getField("name");
    }

    public ProjectMeasuresDoc setName(String s) {
        this.setField("name", s);
        return this;
    }

    @CheckForNull
    public Date getAnalysedAt() {
        return (Date)this.getNullableField("analysedAt");
    }

    public ProjectMeasuresDoc setAnalysedAt(@Nullable Date d) {
        this.setField("analysedAt", d);
        return this;
    }

    public Collection<Map<String, Object>> getMeasures() {
        return (Collection)this.getField("measures");
    }

    public ProjectMeasuresDoc setMeasures(Collection<Map<String, Object>> measures) {
        this.setField("measures", measures);
        return this;
    }

    public ProjectMeasuresDoc setMeasuresFromMap(Map<String, Double> measures) {
        this.setMeasures((Collection)measures.entrySet().stream().map(entry -> ImmutableMap.of((Object)"key", entry.getKey(), (Object)"value", entry.getValue())).collect(MoreCollectors.toList()));
        return this;
    }

    public ProjectMeasuresDoc setLanguages(List<String> languages) {
        this.setField("languages", languages);
        return this;
    }

    public Collection<Map<String, Object>> getNclocLanguageDistribution() {
        return (Collection)this.getField("nclocLanguageDistribution");
    }

    public ProjectMeasuresDoc setNclocLanguageDistribution(Collection<Map<String, Object>> distribution) {
        this.setField("nclocLanguageDistribution", distribution);
        return this;
    }

    public ProjectMeasuresDoc setNclocLanguageDistributionFromMap(Map<String, Integer> distribution) {
        this.setNclocLanguageDistribution((Collection)distribution.entrySet().stream().map(entry -> ImmutableMap.of((Object)"language", entry.getKey(), (Object)"ncloc", entry.getValue())).collect(MoreCollectors.toList()));
        return this;
    }

    public ProjectMeasuresDoc setQualityGateStatus(@Nullable String s) {
        this.setField("qualityGateStatus", s != null ? QUALITY_GATE_STATUS.get(s) : null);
        return this;
    }

    public ProjectMeasuresDoc setTags(List<String> tags) {
        this.setField("tags", tags);
        return this;
    }
}

