/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.notification;

import java.util.Collection;
import java.util.Set;
import org.sonar.api.notifications.Notification;
import org.sonar.server.notification.NotificationHandler;
import org.sonar.server.notification.email.EmailNotificationChannel;

public abstract class EmailNotificationHandler<T extends Notification>
implements NotificationHandler<T> {
    private final EmailNotificationChannel emailChannel;

    protected EmailNotificationHandler(EmailNotificationChannel emailChannel) {
        this.emailChannel = emailChannel;
    }

    @Override
    public int deliver(Collection<T> notifications) {
        if (notifications.isEmpty() || !this.emailChannel.isActivated()) {
            return 0;
        }
        Set<EmailNotificationChannel.EmailDeliveryRequest> requests = this.toEmailDeliveryRequests(notifications);
        if (requests.isEmpty()) {
            return 0;
        }
        return this.emailChannel.deliverAll(requests);
    }

    protected abstract Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<T> var1);
}

