/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.es.IndexType;
import org.sonar.server.permission.index.IndexPermissions;

public class AuthorizationDoc
extends BaseDoc {
    private static final String ID_PREFIX = "auth_";
    private final String projectUuid;

    private AuthorizationDoc(IndexType indexType, String projectUuid) {
        super(indexType);
        this.projectUuid = projectUuid;
    }

    public static AuthorizationDoc fromDto(IndexType indexType, IndexPermissions dto) {
        AuthorizationDoc res = new AuthorizationDoc(indexType, dto.getProjectUuid());
        if (dto.isAllowAnyone()) {
            return res.setAllowAnyone();
        }
        return res.setRestricted(dto.getGroupIds(), dto.getUserIds());
    }

    @Override
    public String getId() {
        return AuthorizationDoc.idOf(this.projectUuid);
    }

    public static String idOf(String projectUuid) {
        Objects.requireNonNull(projectUuid, "projectUuid can't be null");
        return ID_PREFIX + projectUuid;
    }

    public static String projectUuidOf(String id) {
        if (id.startsWith(ID_PREFIX)) {
            return id.substring(ID_PREFIX.length());
        }
        return id;
    }

    @Override
    protected Optional<String> getSimpleMainTypeRouting() {
        return Optional.of(this.projectUuid);
    }

    private AuthorizationDoc setAllowAnyone() {
        this.setField("auth_allowAnyone", true);
        return this;
    }

    private AuthorizationDoc setRestricted(List<Integer> groupIds, List<Integer> userIds) {
        this.setField("auth_allowAnyone", false);
        this.setField("auth_groupIds", groupIds);
        this.setField("auth_userIds", userIds);
        return this;
    }
}

