/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import java.util.ArrayList;
import java.util.List;

public final class IndexPermissions {
    private final String projectUuid;
    private final String qualifier;
    private final List<Integer> userIds = new ArrayList<Integer>();
    private final List<Integer> groupIds = new ArrayList<Integer>();
    private boolean allowAnyone = false;

    public IndexPermissions(String projectUuid, String qualifier) {
        this.projectUuid = projectUuid;
        this.qualifier = qualifier;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public List<Integer> getUserIds() {
        return this.userIds;
    }

    public IndexPermissions addUserId(int l) {
        this.userIds.add(l);
        return this;
    }

    public IndexPermissions addGroupId(int id) {
        this.groupIds.add(id);
        return this;
    }

    public List<Integer> getGroupIds() {
        return this.groupIds;
    }

    public IndexPermissions allowAnyone() {
        this.allowAnyone = true;
        return this;
    }

    public boolean isAllowAnyone() {
        return this.allowAnyone;
    }
}

