/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.monitoring;

import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.server.ServerSide;
import org.sonar.process.systeminfo.SystemInfoSection;
import org.sonar.process.systeminfo.SystemInfoUtils;
import org.sonar.process.systeminfo.protobuf.ProtobufSystemInfo;
import org.sonar.server.log.ServerLogging;

@ComputeEngineSide
@ServerSide
public class LoggingSection
implements SystemInfoSection {
    private final SonarRuntime runtime;
    private final ServerLogging logging;

    public LoggingSection(SonarRuntime runtime, ServerLogging logging) {
        this.runtime = runtime;
        this.logging = logging;
    }

    public ProtobufSystemInfo.Section toProtobuf() {
        ProtobufSystemInfo.Section.Builder protobuf = ProtobufSystemInfo.Section.newBuilder();
        if (this.runtime.getSonarQubeSide() == SonarQubeSide.COMPUTE_ENGINE) {
            protobuf.setName("Compute Engine Logging");
        } else {
            protobuf.setName("Web Logging");
        }
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Logs Level", (String)this.logging.getRootLoggerLevel().name());
        SystemInfoUtils.setAttribute((ProtobufSystemInfo.Section.Builder)protobuf, (String)"Logs Dir", (String)this.logging.getLogsDir().getAbsolutePath());
        return protobuf.build();
    }
}

