/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.measures.Metric;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.ConditionComparator;
import org.sonar.server.qualitygate.EvaluatedCondition;
import org.sonar.server.qualitygate.QualityGate;

@Immutable
public class EvaluatedQualityGate {
    private final QualityGate qualityGate;
    private final Metric.Level status;
    private final Collection<EvaluatedCondition> evaluatedConditions;
    private final boolean ignoredConditionsOnSmallChangeset;

    private EvaluatedQualityGate(QualityGate qualityGate, Metric.Level status, Collection<EvaluatedCondition> evaluatedConditions, boolean ignoredConditionsOnSmallChangeset) {
        this.qualityGate = Objects.requireNonNull(qualityGate, "qualityGate can't be null");
        this.status = Objects.requireNonNull(status, "status can't be null");
        this.evaluatedConditions = evaluatedConditions;
        this.ignoredConditionsOnSmallChangeset = ignoredConditionsOnSmallChangeset;
    }

    public QualityGate getQualityGate() {
        return this.qualityGate;
    }

    public Metric.Level getStatus() {
        return this.status;
    }

    public Collection<EvaluatedCondition> getEvaluatedConditions() {
        return this.evaluatedConditions;
    }

    public boolean hasIgnoredConditionsOnSmallChangeset() {
        return this.ignoredConditionsOnSmallChangeset;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvaluatedQualityGate that = (EvaluatedQualityGate)o;
        return Objects.equals(this.qualityGate, that.qualityGate) && this.status == that.status && Objects.equals(this.evaluatedConditions, that.evaluatedConditions);
    }

    public int hashCode() {
        return Objects.hash(this.qualityGate, this.status, this.evaluatedConditions);
    }

    public String toString() {
        return "EvaluatedQualityGate{qualityGate=" + this.qualityGate + ", status=" + this.status + ", evaluatedConditions=" + this.evaluatedConditions + '}';
    }

    public static final class Builder {
        private QualityGate qualityGate;
        private Metric.Level status;
        private final Map<Condition, EvaluatedCondition> evaluatedConditions = new LinkedHashMap<Condition, EvaluatedCondition>();
        private boolean ignoredConditionsOnSmallChangeset = false;

        private Builder() {
        }

        public Builder setQualityGate(QualityGate qualityGate) {
            this.qualityGate = qualityGate;
            return this;
        }

        public Builder setStatus(Metric.Level status) {
            this.status = status;
            return this;
        }

        public Builder setIgnoredConditionsOnSmallChangeset(boolean b) {
            this.ignoredConditionsOnSmallChangeset = b;
            return this;
        }

        public Builder addEvaluatedCondition(Condition condition, EvaluatedCondition.EvaluationStatus status, @Nullable String value) {
            this.evaluatedConditions.put(condition, new EvaluatedCondition(condition, status, value));
            return this;
        }

        public Builder addEvaluatedCondition(EvaluatedCondition c) {
            this.evaluatedConditions.put(c.getCondition(), c);
            return this;
        }

        public Set<EvaluatedCondition> getEvaluatedConditions() {
            return ImmutableSet.copyOf(this.evaluatedConditions.values());
        }

        public EvaluatedQualityGate build() {
            Builder.checkEvaluatedConditions(this.qualityGate, this.evaluatedConditions);
            ArrayList<EvaluatedCondition> sortedEvaluatedConditions = new ArrayList<EvaluatedCondition>(this.evaluatedConditions.values());
            sortedEvaluatedConditions.sort(new ConditionComparator<EvaluatedCondition>(c -> c.getCondition().getMetricKey()));
            return new EvaluatedQualityGate(this.qualityGate, this.status, sortedEvaluatedConditions, this.ignoredConditionsOnSmallChangeset);
        }

        private static void checkEvaluatedConditions(QualityGate qualityGate, Map<Condition, EvaluatedCondition> evaluatedConditions) {
            Set<Condition> conditions = qualityGate.getConditions();
            Set conditionsNotEvaluated = conditions.stream().filter(c -> !evaluatedConditions.containsKey(c)).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)conditionsNotEvaluated.isEmpty(), (String)"Evaluation missing for the following conditions: %s", (Object[])new Object[]{conditionsNotEvaluated});
            Set unknownConditions = evaluatedConditions.keySet().stream().filter(c -> !conditions.contains(c)).collect(Collectors.toSet());
            Preconditions.checkArgument((boolean)unknownConditions.isEmpty(), (String)"Evaluation provided for unknown conditions: %s", (Object[])new Object[]{unknownConditions});
        }
    }
}

