/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate.notification;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.sonar.api.notifications.Notification;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.notification.EmailNotificationHandler;
import org.sonar.server.notification.NotificationDispatcherMetadata;
import org.sonar.server.notification.NotificationManager;
import org.sonar.server.notification.email.EmailNotificationChannel;
import org.sonar.server.qualitygate.notification.QGChangeNotification;

public class QGChangeNotificationHandler
extends EmailNotificationHandler<QGChangeNotification> {
    public static final String KEY = "NewAlerts";
    private static final NotificationDispatcherMetadata METADATA = NotificationDispatcherMetadata.create("NewAlerts").setProperty("globalNotification", String.valueOf(true)).setProperty("perProjectNotification", String.valueOf(true));
    private final NotificationManager notificationManager;

    public QGChangeNotificationHandler(NotificationManager notificationManager, EmailNotificationChannel emailNotificationChannel) {
        super(emailNotificationChannel);
        this.notificationManager = notificationManager;
    }

    @Override
    public Class<QGChangeNotification> getNotificationClass() {
        return QGChangeNotification.class;
    }

    @Override
    public Optional<NotificationDispatcherMetadata> getMetadata() {
        return Optional.of(METADATA);
    }

    public static NotificationDispatcherMetadata newMetadata() {
        return METADATA;
    }

    @Override
    public Set<EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(Collection<QGChangeNotification> notifications) {
        Multimap notificationsByProjectKey = (Multimap)notifications.stream().filter(t -> t.getProjectKey() != null).collect(MoreCollectors.index(QGChangeNotification::getProjectKey));
        if (notificationsByProjectKey.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)notificationsByProjectKey.asMap().entrySet().stream().flatMap(e -> this.toEmailDeliveryRequests((String)e.getKey(), (Collection)e.getValue())).collect(MoreCollectors.toSet((int)notifications.size()));
    }

    private Stream<? extends EmailNotificationChannel.EmailDeliveryRequest> toEmailDeliveryRequests(String projectKey, Collection<QGChangeNotification> notifications) {
        return this.notificationManager.findSubscribedEmailRecipients(KEY, projectKey, NotificationManager.SubscriberPermissionsOnProject.ALL_MUST_HAVE_ROLE_USER).stream().flatMap(emailRecipient -> notifications.stream().map(notification -> new EmailNotificationChannel.EmailDeliveryRequest(emailRecipient.getEmail(), (Notification)notification)));
    }
}

