/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile;

import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.ActiveRuleKey;
import org.sonar.db.qualityprofile.QProfileChangeDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.server.qualityprofile.ActiveRuleInheritance;

public class ActiveRuleChange {
    private ActiveRuleDto activeRule;
    private final Type type;
    private final ActiveRuleKey key;
    private final int ruleId;
    private String severity = null;
    private ActiveRuleInheritance inheritance = null;
    private final Map<String, String> parameters = new HashMap<String, String>();

    public ActiveRuleChange(Type type, ActiveRuleDto activeRule, RuleDefinitionDto ruleDefinition) {
        this.type = type;
        this.key = activeRule.getKey();
        this.ruleId = ruleDefinition.getId();
        this.activeRule = activeRule;
    }

    public ActiveRuleChange(Type type, ActiveRuleKey key, RuleDefinitionDto ruleDefinition) {
        this.type = type;
        this.key = key;
        this.ruleId = ruleDefinition.getId();
    }

    public ActiveRuleKey getKey() {
        return this.key;
    }

    public int getRuleId() {
        return this.ruleId;
    }

    public Type getType() {
        return this.type;
    }

    @CheckForNull
    public String getSeverity() {
        return this.severity;
    }

    public ActiveRuleChange setSeverity(@Nullable String s) {
        this.severity = s;
        return this;
    }

    public ActiveRuleChange setInheritance(@Nullable ActiveRuleInheritance i) {
        this.inheritance = i;
        return this;
    }

    @CheckForNull
    public ActiveRuleInheritance getInheritance() {
        return this.inheritance;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public ActiveRuleChange setParameter(String key, @Nullable String value) {
        this.parameters.put(key, value);
        return this;
    }

    public ActiveRuleChange setParameters(Map<String, String> m) {
        this.parameters.clear();
        this.parameters.putAll(m);
        return this;
    }

    @CheckForNull
    public ActiveRuleDto getActiveRule() {
        return this.activeRule;
    }

    public ActiveRuleChange setActiveRule(@Nullable ActiveRuleDto activeRule) {
        this.activeRule = activeRule;
        return this;
    }

    public QProfileChangeDto toDto(@Nullable String userUuid) {
        QProfileChangeDto dto = new QProfileChangeDto();
        dto.setChangeType(this.type.name());
        dto.setRulesProfileUuid(this.getKey().getRuleProfileUuid());
        dto.setUserUuid(userUuid);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("ruleId", String.valueOf(this.getRuleId()));
        this.parameters.entrySet().stream().filter(param -> !((String)param.getKey()).isEmpty()).forEach(param -> data.put("param_" + (String)param.getKey(), (String)param.getValue()));
        if (StringUtils.isNotEmpty((String)this.severity)) {
            data.put("severity", this.severity);
        }
        if (this.inheritance != null) {
            data.put("inheritance", this.inheritance.name());
        }
        dto.setData(data);
        return dto;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("key", (Object)this.key).add("ruleId", this.ruleId).add("severity", (Object)this.severity).add("inheritance", (Object)this.inheritance).add("parameters", this.parameters).toString();
    }

    public static enum Type {
        ACTIVATED,
        DEACTIVATED,
        UPDATED;

    }
}

