/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.analyzers;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Attribute;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

public class ComplexityVisitor
extends AbstractPageCheck {
    private static final String[] OPERATORS = new String[]{"&&", "||", "and", "or"};
    private static final String[] TAGS = new String[]{"catch", "choose", "if", "forEach", "forTokens", "when"};
    private int complexity;

    @Override
    public void startDocument(List<Node> nodes) {
        this.complexity = 1;
    }

    @Override
    public void endDocument() {
        this.getHtmlSourceCode().addMeasure((Metric<Integer>)CoreMetrics.COMPLEXITY, this.complexity);
    }

    @Override
    public void startElement(TagNode node) {
        if (ArrayUtils.contains(TAGS, node.getLocalName()) || ArrayUtils.contains(TAGS, node.getNodeName())) {
            ++this.complexity;
        } else {
            for (Attribute a : node.getAttributes()) {
                String[] tokens;
                if (!this.isUnifiedExpression(a.getValue())) continue;
                for (String token : tokens = StringUtils.split(a.getValue(), " \t\n")) {
                    if (!ArrayUtils.contains(OPERATORS, token)) continue;
                    ++this.complexity;
                }
            }
        }
    }
}

