/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.header;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.Node;

@Rule(key="MultiplePageDirectivesCheck")
public class MultiplePageDirectivesCheck
extends AbstractPageCheck {
    private DirectiveNode node;
    private int pageDirectives;

    @Override
    public void directive(DirectiveNode node) {
        if (!node.isHtml() && "page".equalsIgnoreCase(node.getNodeName()) && !MultiplePageDirectivesCheck.isImportDirective(node)) {
            ++this.pageDirectives;
            this.node = node;
        }
    }

    @Override
    public void endDocument() {
        if (this.pageDirectives > 1) {
            this.createViolation(this.node.getStartLinePosition(), "Combine these " + this.pageDirectives + " page directives into one.");
        }
    }

    @Override
    public void startDocument(List<Node> nodes) {
        this.pageDirectives = 0;
    }

    private static boolean isImportDirective(DirectiveNode node) {
        return node.getAttributes().size() == 1 && node.getAttribute("import") != null;
    }
}

