/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.Node;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="InputWithoutLabelCheck")
public class InputWithoutLabelCheck
extends AbstractPageCheck {
    private static final Set<String> EXCLUDED_TYPES = ImmutableSet.of("SUBMIT", "BUTTON", "IMAGE", "HIDDEN");
    private final Set<String> labelFor = Sets.newHashSet();
    private final Map<String, Integer> inputIdToLine = Maps.newHashMap();

    @Override
    public void startDocument(List<Node> nodes) {
        this.labelFor.clear();
        this.inputIdToLine.clear();
    }

    @Override
    public void startElement(TagNode node) {
        if (InputWithoutLabelCheck.isInputRequiredLabel(node) || InputWithoutLabelCheck.isSelect(node) || InputWithoutLabelCheck.isTextarea(node)) {
            String id = node.getAttribute("id");
            if (id == null) {
                this.createViolation(node.getStartLinePosition(), "Add an \"id\" attribute to this input field and associate it with a label.");
            } else {
                this.inputIdToLine.put(node.getAttribute("id"), node.getStartLinePosition());
            }
        } else if (InputWithoutLabelCheck.isLabel(node) && node.getAttribute("for") != null) {
            this.labelFor.add(node.getAttribute("for"));
        }
    }

    private static boolean isSelect(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "SELECT");
    }

    private static boolean isTextarea(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "TEXTAREA");
    }

    private static boolean isInputRequiredLabel(TagNode node) {
        return InputWithoutLabelCheck.isType(node, "INPUT") && !InputWithoutLabelCheck.hasExcludedType(node);
    }

    private static boolean isType(TagNode node, String type) {
        return type.equalsIgnoreCase(node.getNodeName());
    }

    private static boolean hasExcludedType(TagNode node) {
        String type = node.getAttribute("type");
        return type == null || EXCLUDED_TYPES.contains(type.toUpperCase(Locale.ENGLISH));
    }

    private static boolean isLabel(TagNode node) {
        return "LABEL".equalsIgnoreCase(node.getNodeName());
    }

    @Override
    public void endDocument() {
        for (Map.Entry<String, Integer> entry : this.inputIdToLine.entrySet()) {
            if (this.labelFor.contains(entry.getKey())) continue;
            this.createViolation(entry.getValue(), "Associate a valid label to this input field.");
        }
    }
}

