/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.sonar;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.TagNode;

@Rule(key="TableHeaderHasIdOrScopeCheck")
public class TableHeaderHasIdOrScopeCheck
extends AbstractPageCheck {
    @Override
    public void startElement(TagNode node) {
        if (TableHeaderHasIdOrScopeCheck.isTableHeader(node) && !node.hasProperty("ID") && !node.hasProperty("SCOPE")) {
            this.createViolation(node.getStartLinePosition(), "Add either an 'id' or a 'scope' attribute to this <" + node.getNodeName() + "> tag.");
        }
    }

    private static boolean isTableHeader(TagNode node) {
        return "TH".equalsIgnoreCase(node.getNodeName());
    }
}

