/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.checks.whitespace;

import org.sonar.check.Rule;
import org.sonar.plugins.html.checks.AbstractPageCheck;
import org.sonar.plugins.html.node.CommentNode;
import org.sonar.plugins.html.node.DirectiveNode;
import org.sonar.plugins.html.node.ExpressionNode;
import org.sonar.plugins.html.node.Node;

@Rule(key="WhiteSpaceAroundCheck")
public class WhiteSpaceAroundCheck
extends AbstractPageCheck {
    private void checkEndWhitespace(Node node, String code, String end) {
        char ch;
        int position = end.length();
        if (code.endsWith(end) && code.length() > position && !Character.isWhitespace(ch = code.charAt(code.length() - position - 1))) {
            this.createViolation(node.getStartLinePosition(), "Add a space at column " + (node.getEndColumnPosition() - position) + ".");
        }
    }

    private void checkStartWhitespace(Node node, String code, String start) {
        int position = start.length();
        if (code.startsWith(start) && code.length() > position) {
            char ch = code.charAt(position);
            switch (ch) {
                case '!': 
                case '=': {
                    this.handleEqualSign(node, code, position);
                    break;
                }
                default: {
                    if (Character.isWhitespace(ch)) break;
                    this.createStartIssue(node.getStartLinePosition(), node.getStartColumnPosition() + position);
                }
            }
        }
    }

    private void handleEqualSign(Node node, String code, int position) {
        int tmpPosition = position + 1;
        if (code.length() > tmpPosition && !Character.isWhitespace(code.charAt(tmpPosition))) {
            this.createStartIssue(node.getStartLinePosition(), node.getStartColumnPosition() + tmpPosition);
        }
    }

    private void createStartIssue(int line, int expectedWhitespaceColumn) {
        this.createViolation(line, "A whitespace is missing after the starting tag at column " + expectedWhitespaceColumn + ".");
    }

    @Override
    public void comment(CommentNode node) {
        if (node.isHtml()) {
            this.checkStartWhitespace(node, node.getCode(), "<!--");
            this.checkEndWhitespace(node, node.getCode(), "-->");
        } else {
            this.checkStartWhitespace(node, node.getCode(), "<%--");
            this.checkEndWhitespace(node, node.getCode(), "--%>");
        }
    }

    @Override
    public void directive(DirectiveNode node) {
        if (node.isJsp()) {
            this.checkStartWhitespace(node, node.getCode(), "<%@");
            this.checkEndWhitespace(node, node.getCode(), "%>");
        }
    }

    @Override
    public void expression(ExpressionNode node) {
        this.checkStartWhitespace(node, node.getCode(), "<%");
        this.checkEndWhitespace(node, node.getCode(), "%>");
    }
}

