/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.lex;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.sonar.channel.Channel;
import org.sonar.channel.CodeReader;
import org.sonar.channel.EndMatcher;
import org.sonar.plugins.html.node.Node;

abstract class AbstractTokenizer<T extends List<Node>>
extends Channel<T> {
    private final char[] endChars;
    private final char[] startChars;

    public AbstractTokenizer(String startChars, String endChars) {
        this.startChars = startChars.toCharArray();
        this.endChars = endChars.toCharArray();
    }

    protected void addNode(List<Node> nodeList, Node node) {
        nodeList.add(node);
    }

    @Override
    public boolean consume(CodeReader codeReader, T nodeList) {
        if (AbstractTokenizer.equalsIgnoreCase(codeReader.peek(this.startChars.length), this.startChars)) {
            Node node = this.createNode();
            this.setStartPosition(codeReader, node);
            StringBuilder stringBuilder = new StringBuilder();
            codeReader.popTo(this.getEndMatcher(codeReader), (Appendable)stringBuilder);
            for (int i = 0; i < this.endChars.length; ++i) {
                codeReader.pop(stringBuilder);
            }
            node.setCode(stringBuilder.toString());
            this.setEndPosition(codeReader, node);
            this.addNode((List<Node>)nodeList, node);
            return true;
        }
        return false;
    }

    abstract Node createNode();

    protected final void setEndPosition(CodeReader code, Node node) {
        node.setEndLinePosition(code.getLinePosition());
        node.setEndColumnPosition(code.getColumnPosition());
    }

    protected final void setStartPosition(CodeReader code, Node node) {
        node.setStartLinePosition(code.getLinePosition());
        node.setStartColumnPosition(code.getColumnPosition());
    }

    private static boolean equalsIgnoreCase(char[] a, char[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (Character.toLowerCase(a[i]) == Character.toLowerCase(b[i])) continue;
            return false;
        }
        return true;
    }

    protected EndMatcher getEndMatcher(CodeReader codeReader) {
        return new EndTokenMatcher(codeReader);
    }

    private final class EndTokenMatcher
    implements EndMatcher {
        private final CodeReader codeReader;
        private boolean quoting;
        private int nesting;

        private EndTokenMatcher(CodeReader codeReader) {
            this.codeReader = codeReader;
        }

        @Override
        public boolean match(int endFlag) {
            if (endFlag == 34) {
                boolean bl = this.quoting = !this.quoting;
            }
            if (!this.quoting) {
                boolean started = AbstractTokenizer.equalsIgnoreCase(this.codeReader.peek(AbstractTokenizer.this.startChars.length), AbstractTokenizer.this.startChars);
                if (started) {
                    ++this.nesting;
                } else {
                    boolean ended = ArrayUtils.isEquals(this.codeReader.peek(AbstractTokenizer.this.endChars.length), AbstractTokenizer.this.endChars);
                    if (ended) {
                        --this.nesting;
                        return this.nesting < 0;
                    }
                }
            }
            return false;
        }
    }
}

