/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.html.visitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.measures.Metric;
import org.sonar.plugins.html.checks.HtmlIssue;

public class HtmlSourceCode {
    private final InputFile inputFile;
    private final Map<Metric<Integer>, Integer> measures = new HashMap<Metric<Integer>, Integer>();
    private final List<HtmlIssue> issues = new ArrayList<HtmlIssue>();
    private Set<Integer> detailedLinesOfCode = new HashSet<Integer>();

    public HtmlSourceCode(InputFile inputFile) {
        this.inputFile = inputFile;
    }

    public InputFile inputFile() {
        return this.inputFile;
    }

    public void addMeasure(Metric<Integer> metric, int value) {
        if (this.shouldComputeMetric()) {
            this.measures.put(metric, value);
        }
    }

    public void addIssue(HtmlIssue issue) {
        this.issues.add(issue);
    }

    public Integer getMeasure(Metric metric) {
        return this.measures.get(metric);
    }

    public Map<Metric<Integer>, Integer> getMeasures() {
        return this.measures;
    }

    public List<HtmlIssue> getIssues() {
        return this.issues;
    }

    public String toString() {
        return this.inputFile().toString();
    }

    public Set<Integer> getDetailedLinesOfCode() {
        return this.detailedLinesOfCode;
    }

    public void setDetailedLinesOfCode(Set<Integer> detailedLinesOfCode) {
        this.detailedLinesOfCode = detailedLinesOfCode;
    }

    public boolean shouldComputeMetric() {
        String language = this.inputFile.language();
        return language == null || "web".equals(language) || "jsp".equals(language);
    }
}

