/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.common.util.concurrent.ListenableFuture;

public final class StepListener<Response>
implements ActionListener<Response> {
    private final ListenableFuture<Response> delegate = new ListenableFuture();

    @Override
    public void onResponse(Response response) {
        this.delegate.onResponse(response);
    }

    @Override
    public void onFailure(Exception e) {
        this.delegate.onFailure(e);
    }

    public void whenComplete(CheckedConsumer<Response, Exception> onResponse, Consumer<Exception> onFailure) {
        this.delegate.addListener(ActionListener.wrap(onResponse, onFailure), EsExecutors.newDirectExecutorService(), null);
    }

    public Response result() {
        if (!this.delegate.isDone()) {
            throw new IllegalStateException("step is not completed yet");
        }
        return FutureUtils.get(this.delegate, 0L, TimeUnit.NANOSECONDS);
    }
}

