/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.jacoco;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.plugins.jacoco.ReversePathTree;

public class FileLocator {
    private final ReversePathTree tree = new ReversePathTree();

    public FileLocator(Iterable<InputFile> inputFiles) {
        this(StreamSupport.stream(inputFiles.spliterator(), false).collect(Collectors.toList()));
    }

    public FileLocator(List<InputFile> inputFiles) {
        for (InputFile inputFile : inputFiles) {
            String[] path = inputFile.relativePath().split("/");
            this.tree.index(inputFile, path);
        }
    }

    @CheckForNull
    public InputFile getInputFile(String packagePath, String fileName) {
        String filePath = packagePath + "/" + fileName;
        String[] path = filePath.split("/");
        return this.tree.getFileWithSuffix(path);
    }
}

