/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.xml.checks;

import java.util.ArrayList;
import java.util.Collections;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.xml.Utils;
import org.sonarsource.analyzer.commons.xml.XmlFile;
import org.sonarsource.analyzer.commons.xml.checks.SonarXmlCheck;

@Rule(key="IllegalTabCheck")
public class TabCharacterCheck
extends SonarXmlCheck {
    public static final String RULE_KEY = "IllegalTabCheck";
    @RuleProperty(key="markAll", description="Mark all tab errors", defaultValue="false", type="BOOLEAN")
    private boolean markAll;

    @Override
    public void scanFile(XmlFile file) {
        int lineNumber = 1;
        ArrayList<Integer> secondaries = new ArrayList<Integer>();
        for (String line : Utils.splitLines(file.getContents())) {
            if (line.indexOf(9) != -1) {
                secondaries.add(lineNumber);
                if (!this.markAll) break;
            }
            ++lineNumber;
        }
        if (!secondaries.isEmpty()) {
            this.reportIssueOnFile("Replace all tab characters in this file by sequences of white-spaces.", this.markAll ? secondaries : Collections.emptyList());
        }
    }

    public void setMarkAll(boolean markAll) {
        this.markAll = markAll;
    }
}

