/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.application;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.sonar.api.SonarEdition;
import org.sonar.api.internal.MetadataLoader;
import org.sonar.api.utils.System2;
import org.sonar.application.AppFileSystem;
import org.sonar.application.AppLogging;
import org.sonar.application.AppReloaderImpl;
import org.sonar.application.AppState;
import org.sonar.application.AppStateFactory;
import org.sonar.application.HardStopRequestWatcherImpl;
import org.sonar.application.ProcessLauncherImpl;
import org.sonar.application.Scheduler;
import org.sonar.application.SchedulerImpl;
import org.sonar.application.StopRequestWatcher;
import org.sonar.application.StopRequestWatcherImpl;
import org.sonar.application.command.CommandFactoryImpl;
import org.sonar.application.command.JavaVersion;
import org.sonar.application.config.AppSettings;
import org.sonar.application.config.AppSettingsLoaderImpl;
import org.sonar.application.config.SonarQubeVersionHelper;
import org.sonar.core.extension.ServiceLoaderWrapper;
import org.sonar.process.ProcessProperties;
import org.sonar.process.SystemExit;

public class App {
    private final SystemExit systemExit = new SystemExit();
    private final JavaVersion javaVersion;
    private StopRequestWatcher stopRequestWatcher = null;
    private StopRequestWatcher hardStopRequestWatcher = null;

    public App(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void start(String[] cliArguments) throws IOException, InterruptedException {
        AppSettingsLoaderImpl settingsLoader = new AppSettingsLoaderImpl(cliArguments, new ServiceLoaderWrapper());
        AppSettings settings = settingsLoader.load();
        AppLogging logging = new AppLogging(settings);
        logging.configure();
        AppFileSystem fileSystem = new AppFileSystem(settings);
        this.checkJavaVersion();
        try (AppState appState = new AppStateFactory(settings).create();){
            appState.registerSonarQubeVersion(SonarQubeVersionHelper.getSonarqubeVersion());
            appState.registerClusterName(settings.getProps().nonNullValue(ProcessProperties.Property.CLUSTER_NAME.getKey()));
            AppReloaderImpl appReloader = new AppReloaderImpl(settingsLoader, fileSystem, appState, logging);
            fileSystem.reset();
            CommandFactoryImpl commandFactory = new CommandFactoryImpl(settings.getProps(), fileSystem.getTempDir(), org.sonar.process.System2.INSTANCE, JavaVersion.INSTANCE);
            try (ProcessLauncherImpl processLauncher = new ProcessLauncherImpl(fileSystem.getTempDir());){
                SchedulerImpl scheduler = new SchedulerImpl(settings, appReloader, commandFactory, processLauncher, appState);
                scheduler.schedule();
                this.stopRequestWatcher = StopRequestWatcherImpl.create(settings, scheduler, fileSystem);
                this.hardStopRequestWatcher = HardStopRequestWatcherImpl.create(scheduler, fileSystem);
                Runtime.getRuntime().addShutdownHook(new ShutdownHook(scheduler));
                this.stopRequestWatcher.startWatching();
                this.hardStopRequestWatcher.startWatching();
                scheduler.awaitTermination();
                this.hardStopRequestWatcher.stopWatching();
            }
        }
        this.systemExit.exit(0);
    }

    private void checkJavaVersion() {
        if (MetadataLoader.loadEdition((System2)System2.INSTANCE) == SonarEdition.SONARCLOUD) {
            return;
        }
        Preconditions.checkState((boolean)this.javaVersion.isAtLeastJava11(), (Object)"SonarQube requires Java 11 to run");
    }

    public static void main(String[] args) throws Exception {
        new App(JavaVersion.INSTANCE).start(args);
    }

    private class ShutdownHook
    extends Thread {
        private final Scheduler scheduler;

        public ShutdownHook(Scheduler scheduler) {
            super("Shutdown Hook");
            this.scheduler = scheduler;
        }

        @Override
        public void run() {
            App.this.systemExit.setInShutdownHook();
            App.this.stopRequestWatcher.stopWatching();
            App.this.hardStopRequestWatcher.stopWatching();
            this.scheduler.stop();
        }
    }
}

