/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.IOException;
import javax.annotation.CheckForNull;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsParser;
import org.sonar.plugins.dotnet.tests.XmlParserHelper;

public class NUnitTestResultsFileParser
implements UnitTestResultsParser {
    private static final Logger LOG = Loggers.get(NUnitTestResultsFileParser.class);

    @Override
    public void accept(File file, UnitTestResults unitTestResults) {
        LOG.info("Parsing the NUnit Test Results file " + file.getAbsolutePath());
        new Parser(file, unitTestResults).parse();
    }

    private static class Parser {
        private final File file;
        private final UnitTestResults unitTestResults;

        Parser(File file, UnitTestResults unitTestResults) {
            this.file = file;
            this.unitTestResults = unitTestResults;
        }

        public void parse() {
            block16: {
                try (XmlParserHelper xmlParserHelper = new XmlParserHelper(this.file);){
                    String rootTag = xmlParserHelper.nextStartTag();
                    if ("test-results".equals(rootTag)) {
                        this.handleTestResultsTag(xmlParserHelper);
                        break block16;
                    }
                    if ("test-run".equals(rootTag)) {
                        this.handleTestRunTag(xmlParserHelper);
                        break block16;
                    }
                    throw xmlParserHelper.parseError("Unrecognized root element <" + rootTag + ">");
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to close report", e);
                }
            }
        }

        private void handleTestResultsTag(XmlParserHelper xmlParserHelper) {
            int total = xmlParserHelper.getRequiredIntAttribute("total");
            int errors = xmlParserHelper.getRequiredIntAttribute("errors");
            int failures = xmlParserHelper.getRequiredIntAttribute("failures");
            int inconclusive = xmlParserHelper.getRequiredIntAttribute("inconclusive");
            int ignored = xmlParserHelper.getRequiredIntAttribute("ignored");
            int skipped = xmlParserHelper.getRequiredIntAttribute("skipped");
            int totalSkipped = skipped + inconclusive + ignored;
            Double duration = Parser.readExecutionTimeFromDirectlyNestedTestSuiteTags(xmlParserHelper);
            Long executionTime = duration != null ? Long.valueOf((long)duration.doubleValue()) : null;
            this.unitTestResults.add(total, totalSkipped, failures, errors, executionTime);
        }

        private void handleTestRunTag(XmlParserHelper xmlParserHelper) {
            int total = xmlParserHelper.getRequiredIntAttribute("total");
            int failures = xmlParserHelper.getRequiredIntAttribute("failed");
            int inconclusive = xmlParserHelper.getRequiredIntAttribute("inconclusive");
            int skipped = xmlParserHelper.getRequiredIntAttribute("skipped");
            int totalSkipped = skipped + inconclusive;
            Double duration = xmlParserHelper.getDoubleAttribute("duration");
            Long executionTime = duration != null ? Long.valueOf((long)(duration * 1000.0)) : null;
            int errors = Parser.readErrorCountFromNestedTestCaseTags(xmlParserHelper);
            this.unitTestResults.add(total, totalSkipped, failures, errors, executionTime);
        }

        @CheckForNull
        private static Double readExecutionTimeFromDirectlyNestedTestSuiteTags(XmlParserHelper xmlParserHelper) {
            String tag;
            Double executionTime = null;
            int level = 0;
            while ((tag = xmlParserHelper.nextStartOrEndTag()) != null) {
                if ("<test-suite>".equals(tag)) {
                    Double time = xmlParserHelper.getDoubleAttribute("time");
                    if (++level != 1 || time == null) continue;
                    if (executionTime == null) {
                        executionTime = 0.0;
                    }
                    executionTime = executionTime + time * 1000.0;
                    continue;
                }
                if (!"</test-suite>".equals(tag)) continue;
                --level;
            }
            return executionTime;
        }

        private static int readErrorCountFromNestedTestCaseTags(XmlParserHelper xmlParserHelper) {
            String tag;
            int errors = 0;
            int level = 0;
            while ((tag = xmlParserHelper.nextStartOrEndTag()) != null) {
                if ("<test-case>".equals(tag)) {
                    String label = xmlParserHelper.getAttribute("label");
                    if (++level != 1 || !"Error".equals(label)) continue;
                    ++errors;
                    continue;
                }
                if (!"</test-case>".equals(tag)) continue;
                --level;
            }
            return errors;
        }
    }
}

