/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.github;

import org.sonarsource.auth.github.GsonUser;

class UserIdentityGenerator {
    private UserIdentityGenerator() {
    }

    static String generateLogin(GsonUser gsonUser, String loginStrategy) {
        switch (loginStrategy) {
            case "Same as GitHub login": {
                return gsonUser.getLogin();
            }
            case "Unique": {
                return UserIdentityGenerator.generateUniqueLogin(gsonUser);
            }
        }
        throw new IllegalStateException(String.format("Login strategy not supported : %s", loginStrategy));
    }

    static String generateName(GsonUser gson) {
        String name = gson.getName();
        return name == null || name.isEmpty() ? gson.getLogin() : name;
    }

    private static String generateUniqueLogin(GsonUser gsonUser) {
        return String.format("%s@%s", gsonUser.getLogin(), "github");
    }
}

