/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Type;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.sonar.api.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.TempFolder;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.ExternalProcessStreamConsumer;
import org.sonar.plugin.typescript.SensorContextUtils;
import org.sonar.plugin.typescript.executable.ExecutableBundle;
import org.sonar.plugin.typescript.executable.ExecutableBundleFactory;
import org.sonarsource.api.sonarlint.SonarLintSide;

@SonarLintSide(lifespan="MULTIPLE_ANALYSES")
public class ContextualServer
implements Startable {
    private static final String TYPESCRIPT_DEPENDENCY_LOCATION_PROPERTY = "sonar.typescript.internal.typescriptLocation";
    private static final int DEFAULT_TIMEOUT_MS = 5000;
    private static final Logger LOG = Loggers.get(ContextualServer.class);
    private static final Gson GSON = new Gson();
    private final Configuration configuration;
    private final ExecutableBundleFactory bundleFactory;
    private final TempFolder tempFolder;
    private final ExternalProcessStreamConsumer externalProcessStreamConsumer;
    private final int connectionTimeout;
    private Process serverProcess;
    private ServerSocket serverSocket;
    private Socket socket;

    public ContextualServer(Configuration configuration, ExecutableBundleFactory bundleFactory, TempFolder tempFolder) {
        this(configuration, bundleFactory, tempFolder, 5000);
    }

    ContextualServer(Configuration configuration, ExecutableBundleFactory bundleFactory, TempFolder tempFolder, int connectionTimeout) {
        this.configuration = configuration;
        this.bundleFactory = bundleFactory;
        this.tempFolder = tempFolder;
        this.connectionTimeout = connectionTimeout;
        this.externalProcessStreamConsumer = new ExternalProcessStreamConsumer();
    }

    public void start() {
        Optional typescriptLocation = this.configuration.get(TYPESCRIPT_DEPENDENCY_LOCATION_PROPERTY);
        if (!typescriptLocation.isPresent()) {
            LOG.debug("No value provided by SonarLint for TypeScript location; property sonar.typescript.internal.typescriptLocation is missing");
            LOG.debug("Skipping SonarTS Server start.");
            return;
        }
        if (this.isAlive()) {
            LOG.debug("Skipping SonarTS Server start, already running");
            return;
        }
        LOG.info("Starting SonarTS Server");
        this.startSonarTSServer(new File((String)typescriptLocation.get()));
    }

    synchronized SensorContextUtils.AnalysisResponse analyze(SensorContextUtils.ContextualAnalysisRequest request) throws IOException {
        if (!this.isAlive()) {
            throw new IllegalStateException("ContextualServer is not started.");
        }
        OutputStreamWriter writer = new OutputStreamWriter(this.socket.getOutputStream(), StandardCharsets.UTF_8);
        String requestJson = GSON.toJson(request);
        writer.append(requestJson);
        writer.flush();
        JsonReader jsonReader = new JsonReader(new InputStreamReader(this.socket.getInputStream(), StandardCharsets.UTF_8));
        return (SensorContextUtils.AnalysisResponse)GSON.fromJson(jsonReader, (Type)((Object)SensorContextUtils.AnalysisResponse.class));
    }

    private void startSonarTSServer(File typescriptLocation) {
        block2: {
            ExecutableBundle bundle = this.bundleFactory.createAndDeploy(this.tempFolder.newDir(), this.configuration);
            try {
                this.serverSocket = new ServerSocket(0);
                this.serverSocket.setSoTimeout(this.connectionTimeout);
                ProcessBuilder processBuilder = new ProcessBuilder(bundle.getSonarTSServerCommand(this.serverSocket.getLocalPort()).commandLineTokens());
                SensorContextUtils.setNodePath(typescriptLocation, processBuilder);
                this.serverProcess = processBuilder.start();
                this.externalProcessStreamConsumer.start();
                this.externalProcessStreamConsumer.consumeStream(this.serverProcess.getErrorStream(), arg_0 -> ((Logger)LOG).error(arg_0));
                this.externalProcessStreamConsumer.consumeStream(this.serverProcess.getInputStream(), arg_0 -> ((Logger)LOG).info(arg_0));
                this.socket = this.serverSocket.accept();
                LOG.info("SonarTS Server is started");
            }
            catch (IOException e) {
                LOG.error("Failed to start SonarTS Server", (Throwable)e);
                if (!this.isAlive()) break block2;
                this.terminate();
            }
        }
    }

    public void stop() {
        if (this.isAlive()) {
            this.terminate();
            LOG.info("SonarTS Server is stopped");
        } else {
            LOG.debug("SonarTS Server was already stopped");
        }
        this.externalProcessStreamConsumer.stop();
    }

    private void terminate() {
        try {
            IOUtils.closeQuietly(this.socket);
            IOUtils.closeQuietly(this.serverSocket);
            this.serverProcess.destroy();
            boolean terminated = this.serverProcess.waitFor(this.connectionTimeout, TimeUnit.MILLISECONDS);
            if (!terminated) {
                this.serverProcess.destroyForcibly();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    boolean isAlive() {
        return this.serverProcess != null && this.serverProcess.isAlive();
    }
}

