/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.executable;

import com.google.gson.Gson;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Configuration;
import org.sonar.plugin.typescript.SensorContextUtils;
import org.sonar.plugin.typescript.TypeScriptRules;
import org.sonar.plugin.typescript.executable.ExecutableBundle;
import org.sonar.plugin.typescript.executable.SonarTSCommand;

public class SonarTSCoreBundle
implements ExecutableBundle {
    private static final int NODE_PROCESS_MEMORY = 2048;
    private static final String BIN = "node_modules/tslint-sonarts/bin/";
    private final Configuration configuration;
    private final File sonartsRunnerExecutable;
    private final File sonartsServerExecutable;

    public SonarTSCoreBundle(File deployDir, Configuration configuration) {
        this.configuration = configuration;
        this.sonartsRunnerExecutable = new File(deployDir, "node_modules/tslint-sonarts/bin/tsrunner");
        this.sonartsServerExecutable = new File(deployDir, "node_modules/tslint-sonarts/bin/sonarts-server");
    }

    @Override
    public SonarTSCommand getSonarTsRunnerCommand() {
        return this.getCommand(this.sonartsRunnerExecutable, new String[0]);
    }

    @Override
    public String getRequestForRunner(String tsconfigPath, Iterable<InputFile> inputFiles, TypeScriptRules typeScriptRules, String projectRoot) {
        SonarTSRequest request = new SonarTSRequest();
        request.filepaths = (String[])StreamSupport.stream(inputFiles.spliterator(), false).map(inputFile -> Paths.get(inputFile.uri()).toString()).toArray(String[]::new);
        request.tsconfig = tsconfigPath;
        request.rules = SensorContextUtils.convertToRulesToExecute(typeScriptRules);
        request.projectRoot = projectRoot;
        return new Gson().toJson(request);
    }

    private SonarTSCommand getCommand(File executable, String ... additionalArgs) {
        String increaseMemory = "--max-old-space-size=2048";
        Stream<String> args = Stream.of(this.getNodeExecutable(), increaseMemory, executable.getAbsolutePath());
        return new SonarTSCommand((String[])Stream.concat(args, Arrays.stream(additionalArgs)).toArray(String[]::new));
    }

    @Override
    public String getNodeExecutable() {
        String nodeExecutable;
        File file;
        Optional nodeExecutableOptional = this.configuration.get("sonar.typescript.node");
        if (nodeExecutableOptional.isPresent() && (file = new File(nodeExecutable = (String)nodeExecutableOptional.get())).exists()) {
            return nodeExecutable;
        }
        return "node";
    }

    @Override
    public SonarTSCommand getSonarTSServerCommand(int port) {
        return this.getCommand(this.sonartsServerExecutable, String.valueOf(port));
    }

    private static class SonarTSRequest {
        String[] filepaths;
        String tsconfig;
        List<SensorContextUtils.RuleToExecute> rules;
        String projectRoot;

        private SonarTSRequest() {
        }
    }
}

