/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.externalreport;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.fs.FilePredicates;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.rule.CheckFactory;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.batch.sensor.issue.NewExternalIssue;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.TypeScriptRules;
import org.sonar.plugin.typescript.externalreport.TSLintRulesDefinition;
import org.sonarsource.analyzer.commons.ExternalReportProvider;

public class TslintReportSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(TslintReportSensor.class);
    protected static final Gson gson = new Gson();
    private static final long DEFAULT_REMEDIATION_COST = 5L;
    private static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    private static final String LINER_NAME = "TSLint";
    private static final String FILE_EXCEPTION_MESSAGE = "No issues information will be saved as the report file can't be read.";
    private final Map<String, String> activatedRules = new HashMap<String, String>();
    static final String REPOSITORY = "tslint";

    public TslintReportSensor(CheckFactory checkFactory) {
        TypeScriptRules typeScriptRules = new TypeScriptRules(checkFactory);
        typeScriptRules.forEach(typeScriptRule -> {
            if (typeScriptRule.isEnabled()) {
                String tsLintKey = typeScriptRule.tsLintKey();
                this.activatedRules.put(tsLintKey, typeScriptRules.ruleKeyFromTsLintKey(tsLintKey).toString());
            }
        });
    }

    public void describe(SensorDescriptor sensorDescriptor) {
        sensorDescriptor.onlyWhenConfiguration(conf -> conf.hasKey("sonar.typescript.tslint.reportPaths")).name("Import of TSLint issues");
    }

    public void execute(SensorContext context) {
        List<File> reportFiles = ExternalReportProvider.getReportFiles(context, "sonar.typescript.tslint.reportPaths");
        for (File reportFile : reportFiles) {
            this.importReport(reportFile, context);
        }
    }

    private static InputFile getInputFile(SensorContext context, String fileName) {
        FilePredicates predicates = context.fileSystem().predicates();
        InputFile inputFile = context.fileSystem().inputFile(predicates.hasPath(fileName));
        if (inputFile == null) {
            LOG.warn("No input file found for {}. No {} issues will be imported on this file.", (Object)fileName, (Object)LINER_NAME);
            return null;
        }
        return inputFile;
    }

    private void importReport(File report, SensorContext context) {
        LOG.info("Importing {}", (Object)report.getAbsoluteFile());
        try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(report), StandardCharsets.UTF_8);){
            TslintError[] tslintErrors;
            for (TslintError tslintError : tslintErrors = gson.fromJson((Reader)inputStreamReader, TslintError[].class)) {
                this.saveTslintError(context, tslintError);
            }
        }
        catch (IOException e) {
            LOG.error(FILE_EXCEPTION_MESSAGE, (Throwable)e);
        }
    }

    private void saveTslintError(SensorContext context, TslintError tslintError) {
        String tslintKey = tslintError.ruleName;
        if (this.activatedRules.containsKey(tslintKey)) {
            String message = "TSLint issue for rule '{}' is skipped because this rule is activated in your SonarQube profile for TypeScript (rule key in SQ {})";
            LOG.debug(message, (Object)tslintKey, (Object)this.activatedRules.get(tslintKey));
            return;
        }
        InputFile inputFile = TslintReportSensor.getInputFile(context, tslintError.name);
        if (inputFile == null) {
            return;
        }
        NewExternalIssue newExternalIssue = context.newExternalIssue();
        NewIssueLocation primaryLocation = newExternalIssue.newLocation().message(tslintError.failure).on((InputComponent)inputFile).at(TslintReportSensor.getLocation(tslintError, inputFile));
        newExternalIssue.at(primaryLocation).forRule(RuleKey.of((String)REPOSITORY, (String)tslintKey)).type(TSLintRulesDefinition.ruleType(tslintKey)).severity(DEFAULT_SEVERITY).remediationEffortMinutes(Long.valueOf(5L)).save();
    }

    private static TextRange getLocation(TslintError tslintError, InputFile inputFile) {
        if (TslintReportSensor.samePosition(tslintError.startPosition, tslintError.endPosition)) {
            return inputFile.selectLine(tslintError.startPosition.line + 1);
        }
        return inputFile.newRange(tslintError.startPosition.line + 1, tslintError.startPosition.character, tslintError.endPosition.line + 1, tslintError.endPosition.character);
    }

    private static boolean samePosition(TslintPosition p1, TslintPosition p2) {
        return p1.line == p2.line && p1.character == p2.character;
    }

    private static class TslintPosition {
        int character;
        int line;

        private TslintPosition() {
        }
    }

    private static class TslintError {
        TslintPosition startPosition;
        TslintPosition endPosition;
        String failure;
        String name;
        String ruleName;

        private TslintError() {
        }
    }
}

