/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugin.typescript.lcov;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugin.typescript.lcov.LCOVParser;

public class LCOVCoverageSensor
implements Sensor {
    private static final Logger LOG = Loggers.get(LCOVCoverageSensor.class);

    public void execute(SensorContext context) {
        List<String> reportPaths = Arrays.asList(context.config().getStringArray("sonar.typescript.lcov.reportPaths"));
        if (!reportPaths.isEmpty()) {
            this.saveMeasureFromLCOVFile(context, reportPaths);
        }
    }

    private void saveMeasureFromLCOVFile(SensorContext context, List<String> reportPaths) {
        int inconsistenciesNumber;
        LinkedList<File> lcovReportFiles = new LinkedList<File>();
        for (String reportPath : reportPaths) {
            File lcovFile = LCOVCoverageSensor.getIOFile(context.fileSystem().baseDir(), reportPath);
            if (lcovFile.isFile()) {
                lcovReportFiles.add(lcovFile);
                continue;
            }
            LOG.warn("No coverage information will be saved because LCOV file cannot be found.");
            LOG.warn("Provided LCOV file path: {}. Seek file with path: {}", (Object)reportPath, (Object)lcovFile.getAbsolutePath());
        }
        if (lcovReportFiles.isEmpty()) {
            LOG.warn("No coverage information will be saved because all LCOV coverage report files cannot be found.");
            return;
        }
        LOG.info("Analysing {}", lcovReportFiles);
        LCOVParser parser = new LCOVParser(context);
        parser.parseReportsAndSaveCoverage(lcovReportFiles);
        List<String> unresolvedPaths = parser.unresolvedPaths();
        if (!unresolvedPaths.isEmpty()) {
            LOG.warn(String.format("Could not resolve %d file paths in %s, first unresolved path: %s", unresolvedPaths.size(), lcovReportFiles, unresolvedPaths.get(0)));
        }
        if ((inconsistenciesNumber = parser.inconsistenciesNumber()) > 0) {
            LOG.warn("Found {} inconsistencies in coverage report. Re-run analyse in debug mode to see details.", (Object)inconsistenciesNumber);
        }
    }

    private static File getIOFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }

    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("ts").name("SonarTS Coverage").onlyOnFileType(InputFile.Type.MAIN).onlyWhenConfiguration(config -> config.hasKey("sonar.typescript.lcov.reportPaths"));
    }
}

