/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonarsource.analyzer.commons.JsonParser;
import org.sonarsource.analyzer.commons.internal.json.simple.JSONArray;

public class ExternalRuleLoader {
    private static final Long DEFAULT_CONSTANT_DEBT_MINUTES = 5L;
    private static final RuleType DEFAULT_ISSUE_TYPE = RuleType.CODE_SMELL;
    private static final Severity DEFAULT_SEVERITY = Severity.MAJOR;
    private static final String DESCRIPTION_ONLY_URL = "See description of %s rule <code>%s</code> at the <a href=\"%s\">%s website</a>.";
    private static final String DESCRIPTION_WITH_URL = "<p>%s</p> <p>See more at the <a href=\"%s\">%s website</a>.</p>";
    private static final String DESCRIPTION_FALLBACK = "This is external rule <code>%s:%s</code>. No details are available.";
    private final String linterKey;
    private final String linterName;
    private final String languageKey;
    private Map<String, ExternalRule> rulesMap = new HashMap<String, ExternalRule>();

    public ExternalRuleLoader(String linterKey, String linterName, String pathToMetadata, String languageKey) {
        this.linterKey = linterKey;
        this.linterName = linterName;
        this.languageKey = languageKey;
        this.loadMetadataFile(pathToMetadata);
    }

    public void createExternalRuleRepository(RulesDefinition.Context context) {
        RulesDefinition.NewRepository externalRepo = context.createExternalRepository(this.linterKey, this.languageKey).setName(this.linterName);
        for (ExternalRule rule : this.rulesMap.values()) {
            RulesDefinition.NewRule newRule = externalRepo.createRule(rule.key).setName(rule.name);
            newRule.setHtmlDescription(rule.getDescription(this.linterKey, this.linterName));
            newRule.setDebtRemediationFunction(newRule.debtRemediationFunctions().constantPerIssue(rule.constantDebtMinutes + "min"));
            newRule.setType(rule.type);
            if (rule.tags != null) {
                newRule.setTags(rule.tags);
            }
            if (rule.severity == null) continue;
            newRule.setSeverity(rule.severity);
        }
        externalRepo.done();
    }

    public Set<String> ruleKeys() {
        return this.rulesMap.keySet();
    }

    public RuleType ruleType(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null) {
            return externalRule.type;
        }
        return DEFAULT_ISSUE_TYPE;
    }

    public Severity ruleSeverity(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null && externalRule.severity != null) {
            return Severity.valueOf((String)externalRule.severity);
        }
        return DEFAULT_SEVERITY;
    }

    public Long ruleConstantDebtMinutes(String ruleKey) {
        ExternalRule externalRule = this.rulesMap.get(ruleKey);
        if (externalRule != null) {
            return externalRule.constantDebtMinutes;
        }
        return DEFAULT_CONSTANT_DEBT_MINUTES;
    }

    private void loadMetadataFile(String pathToMetadata) {
        InputStream inputStream = ExternalRuleLoader.class.getClassLoader().getResourceAsStream(pathToMetadata);
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List<Map<String, Object>> rules = new JsonParser().parseArray(inputStreamReader);
            for (Map<String, Object> rule : rules) {
                ExternalRule externalRule = new ExternalRule(rule);
                this.rulesMap.put(externalRule.key, externalRule);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't read resource: " + pathToMetadata, e);
        }
    }

    private static class ExternalRule {
        final String key;
        final String name;
        final RuleType type;
        @CheckForNull
        final String url;
        @CheckForNull
        final String description;
        @CheckForNull
        final String[] tags;
        @CheckForNull
        final String severity;
        final Long constantDebtMinutes;

        public ExternalRule(Map<String, Object> rule) {
            this.key = (String)rule.get("key");
            this.name = (String)rule.get("name");
            this.url = (String)rule.get("url");
            this.description = (String)rule.get("description");
            this.constantDebtMinutes = (Long)rule.getOrDefault("constantDebtMinutes", DEFAULT_CONSTANT_DEBT_MINUTES);
            JSONArray tagsAsList = (JSONArray)rule.get("tags");
            this.tags = tagsAsList != null ? tagsAsList.toArray(new String[tagsAsList.size()]) : null;
            this.severity = (String)rule.get("severity");
            String inputType = (String)rule.get("type");
            this.type = inputType != null ? RuleType.valueOf((String)inputType) : DEFAULT_ISSUE_TYPE;
        }

        String getDescription(String linterKey, String linterName) {
            if (this.description != null && this.url != null) {
                return String.format(ExternalRuleLoader.DESCRIPTION_WITH_URL, this.description, this.url, linterName);
            }
            if (this.description != null) {
                return this.description;
            }
            if (this.url != null) {
                return String.format(ExternalRuleLoader.DESCRIPTION_ONLY_URL, linterName, this.key, this.url, linterName);
            }
            return String.format(ExternalRuleLoader.DESCRIPTION_FALLBACK, linterKey, this.key);
        }
    }
}

