/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.internal.pmd;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.batch.sensor.cpd.internal.TokensLine;
import org.sonar.duplications.block.Block;
import org.sonar.duplications.block.ByteArray;

@Immutable
public class PmdBlockChunker {
    private static final long PRIME_BASE = 31L;
    private final int blockSize;
    private final long power;

    public PmdBlockChunker(int blockSize) {
        this.blockSize = blockSize;
        long pow = 1L;
        for (int i = 0; i < blockSize - 1; ++i) {
            pow *= 31L;
        }
        this.power = pow;
    }

    public List<Block> chunk(String resourceId, List<TokensLine> fragments) {
        int last;
        ArrayList<TokensLine> filtered = new ArrayList<TokensLine>();
        int i = 0;
        while (i < fragments.size()) {
            int j;
            TokensLine first = fragments.get(i);
            for (j = i + 1; j < fragments.size() && fragments.get(j).getValue().equals(first.getValue()); ++j) {
            }
            filtered.add(fragments.get(i));
            if (i < j - 1) {
                filtered.add(fragments.get(j - 1));
            }
            i = j;
        }
        fragments = filtered;
        if (fragments.size() < this.blockSize) {
            return new ArrayList<Block>();
        }
        TokensLine[] fragmentsArr = fragments.toArray(new TokensLine[fragments.size()]);
        ArrayList<Block> blocks = new ArrayList<Block>(fragmentsArr.length - this.blockSize + 1);
        long hash = 0L;
        int first = 0;
        for (last = 0; last < this.blockSize - 1; ++last) {
            hash = hash * 31L + (long)fragmentsArr[last].getHashCode();
        }
        Block.Builder blockBuilder = Block.builder().setResourceId(resourceId);
        while (last < fragmentsArr.length) {
            TokensLine firstFragment = fragmentsArr[first];
            TokensLine lastFragment = fragmentsArr[last];
            hash = hash * 31L + (long)lastFragment.getHashCode();
            Block block = blockBuilder.setBlockHash(new ByteArray(hash)).setIndexInFile(first).setLines(firstFragment.getStartLine(), lastFragment.getEndLine()).setUnit(firstFragment.getStartUnit(), lastFragment.getEndUnit()).build();
            blocks.add(block);
            hash -= this.power * (long)firstFragment.getHashCode();
            ++last;
            ++first;
        }
        return blocks;
    }
}

