/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.duplications.token;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.sonar.duplications.token.Token;

public class TokenQueue
implements Iterable<Token> {
    private final Deque<Token> tokenQueue;

    public TokenQueue(List<Token> tokenList) {
        this.tokenQueue = new LinkedList<Token>(tokenList);
    }

    public TokenQueue() {
        this.tokenQueue = new LinkedList<Token>();
    }

    public Token peek() {
        return this.tokenQueue.peek();
    }

    public Token poll() {
        return this.tokenQueue.poll();
    }

    public int size() {
        return this.tokenQueue.size();
    }

    public void add(Token token) {
        this.tokenQueue.addLast(token);
    }

    public boolean isNextTokenValue(String expectedValue) {
        Token nextToken = this.tokenQueue.peek();
        if (nextToken == null) {
            return false;
        }
        return nextToken.getValue().equals(expectedValue);
    }

    @Override
    public Iterator<Token> iterator() {
        return this.tokenQueue.iterator();
    }

    public void pushForward(List<Token> matchedTokenList) {
        ListIterator<Token> iter = matchedTokenList.listIterator(matchedTokenList.size());
        while (iter.hasPrevious()) {
            this.tokenQueue.addFirst(iter.previous());
        }
    }
}

