/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(Lifecycle.class);
    private static final Map<State, Set<State>> TRANSITIONS = Lifecycle.buildTransitions();
    private AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    private static Map<State, Set<State>> buildTransitions() {
        EnumMap<State, Set<State>> res = new EnumMap<State, Set<State>>(State.class);
        res.put(State.INIT, Lifecycle.toSet(State.STARTING));
        res.put(State.STARTING, Lifecycle.toSet(State.STARTED, State.STOPPING, State.HARD_STOPPING));
        res.put(State.STARTED, Lifecycle.toSet(State.OPERATIONAL, State.RESTARTING, State.STOPPING, State.HARD_STOPPING));
        res.put(State.OPERATIONAL, Lifecycle.toSet(State.RESTARTING, State.STOPPING, State.HARD_STOPPING));
        res.put(State.RESTARTING, Lifecycle.toSet(State.STARTING, State.HARD_STOPPING));
        res.put(State.STOPPING, Lifecycle.toSet(State.HARD_STOPPING, State.STOPPED));
        res.put(State.HARD_STOPPING, Lifecycle.toSet(State.STOPPED));
        res.put(State.STOPPED, Lifecycle.toSet(new State[0]));
        return res;
    }

    private static Set<State> toSet(State ... states) {
        if (states.length == 0) {
            return Collections.emptySet();
        }
        if (states.length == 1) {
            return Collections.singleton(states[0]);
        }
        return EnumSet.copyOf(Arrays.asList(states));
    }

    public boolean isCurrentState(State candidateState) {
        State currentState = this.state.get();
        boolean res = currentState == candidateState;
        LOG.trace("isCurrentState({}): {} ({})", new Object[]{candidateState, res, currentState});
        return res;
    }

    public boolean tryToMoveTo(State to) {
        AtomicReference lastFrom = new AtomicReference();
        State newState = this.state.updateAndGet(from -> {
            lastFrom.set(from);
            if (TRANSITIONS.get(from).contains((Object)to)) {
                return to;
            }
            return from;
        });
        boolean updated = newState == to && lastFrom.get() != to;
        LOG.trace("tryToMoveTo from {} to {} => {}", new Object[]{lastFrom.get(), to, updated});
        return updated;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lifecycle lifecycle = (Lifecycle)o;
        return this.state.get() == lifecycle.state.get();
    }

    public int hashCode() {
        return this.state.get().hashCode();
    }

    public static enum State {
        INIT,
        STARTING,
        STARTED,
        OPERATIONAL,
        RESTARTING,
        STOPPING,
        HARD_STOPPING,
        STOPPED;

    }
}

