/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.cluster.health;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.process.cluster.health.NodeHealth;
import org.sonar.process.cluster.health.SharedHealthState;
import org.sonar.process.cluster.health.TimestampedNodeHealth;
import org.sonar.process.cluster.hz.HazelcastMember;

public class SharedHealthStateImpl
implements SharedHealthState {
    private static final Logger LOG = LoggerFactory.getLogger(SharedHealthStateImpl.class);
    private static final int TIMEOUT_30_SECONDS = 30000;
    private final HazelcastMember hzMember;

    public SharedHealthStateImpl(HazelcastMember hzMember) {
        this.hzMember = hzMember;
    }

    public SharedHealthStateImpl() {
        this(null);
    }

    @Override
    public void writeMine(NodeHealth nodeHealth) {
        Objects.requireNonNull(nodeHealth, "nodeHealth can't be null");
        Map<String, TimestampedNodeHealth> sqHealthState = this.readReplicatedMap();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reading {} and adding {}", new HashMap<String, TimestampedNodeHealth>(sqHealthState), (Object)nodeHealth);
        }
        sqHealthState.put(this.hzMember.getUuid(), new TimestampedNodeHealth(nodeHealth, this.hzMember.getClusterTime()));
    }

    @Override
    public void clearMine() {
        Map<String, TimestampedNodeHealth> sqHealthState = this.readReplicatedMap();
        String clientUUID = this.hzMember.getUuid();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reading {} and clearing for {}", new HashMap<String, TimestampedNodeHealth>(sqHealthState), (Object)clientUUID);
        }
        sqHealthState.remove(clientUUID);
    }

    @Override
    public Set<NodeHealth> readAll() {
        long clusterTime = this.hzMember.getClusterTime();
        long timeout = clusterTime - 30000L;
        Map<String, TimestampedNodeHealth> sqHealthState = this.readReplicatedMap();
        Set<String> hzMemberUUIDs = this.hzMember.getMemberUuids();
        Set existingNodeHealths = sqHealthState.entrySet().stream().filter(SharedHealthStateImpl.outOfDate(timeout)).filter(SharedHealthStateImpl.ofNonExistentMember(hzMemberUUIDs)).map(entry -> ((TimestampedNodeHealth)entry.getValue()).getNodeHealth()).collect(Collectors.toSet());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Reading {} and keeping {}", new HashMap<String, TimestampedNodeHealth>(sqHealthState), existingNodeHealths);
        }
        return ImmutableSet.copyOf(existingNodeHealths);
    }

    private static Predicate<Map.Entry<String, TimestampedNodeHealth>> outOfDate(long timeout) {
        return entry -> {
            boolean res;
            boolean bl = res = ((TimestampedNodeHealth)entry.getValue()).getTimestamp() > timeout;
            if (!res) {
                LOG.trace("Ignoring NodeHealth of member {} because it is too old", entry.getKey());
            }
            return res;
        };
    }

    private static Predicate<Map.Entry<String, TimestampedNodeHealth>> ofNonExistentMember(Set<String> hzMemberUUIDs) {
        return entry -> {
            boolean res = hzMemberUUIDs.contains(entry.getKey());
            if (!res) {
                LOG.trace("Ignoring NodeHealth of member {} because it is not part of the cluster at the moment", entry.getKey());
            }
            return res;
        };
    }

    private Map<String, TimestampedNodeHealth> readReplicatedMap() {
        return this.hzMember.getReplicatedMap("sq_health_state");
    }
}

