/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import ch.qos.logback.classic.Level;
import java.util.Arrays;
import javax.annotation.CheckForNull;
import org.sonar.process.Props;
import org.sonar.process.logging.RootLoggerConfig;

public abstract class AbstractLogHelper {
    static final Level[] ALLOWED_ROOT_LOG_LEVELS = new Level[]{Level.TRACE, Level.DEBUG, Level.INFO};
    static final String SONAR_LOG_LEVEL_PROPERTY = "sonar.log.level";
    static final String ROLLING_POLICY_PROPERTY = "sonar.log.rollingPolicy";
    static final String MAX_FILES_PROPERTY = "sonar.log.maxFiles";
    private static final String PROCESS_NAME_PLACEHOLDER = "XXXX";
    private static final String THREAD_ID_PLACEHOLDER = "ZZZZ";
    private static final String LOGGER_NAME_PLACEHOLDER = "YYYY";
    private static final String LOG_FORMAT = "%d{yyyy.MM.dd HH:mm:ss} %-5level XXXX[ZZZZ][YYYY] %msg%n";
    private final String loggerNamePattern;

    protected AbstractLogHelper(String loggerNamePattern) {
        this.loggerNamePattern = loggerNamePattern;
    }

    public abstract String getRootLoggerName();

    public String buildLogPattern(RootLoggerConfig config) {
        return LOG_FORMAT.replace(PROCESS_NAME_PLACEHOLDER, config.getProcessId().getKey()).replace(THREAD_ID_PLACEHOLDER, config.getThreadIdFieldPattern()).replace(LOGGER_NAME_PLACEHOLDER, this.loggerNamePattern);
    }

    static Level resolveLevel(Props props, String ... propertyKeys) {
        Level newLevel = Level.INFO;
        for (String propertyKey : propertyKeys) {
            Level level = AbstractLogHelper.getPropertyValueAsLevel(props, propertyKey);
            if (level == null) continue;
            newLevel = level;
        }
        return newLevel;
    }

    @CheckForNull
    static Level getPropertyValueAsLevel(Props props, String propertyKey) {
        String value = props.value(propertyKey);
        if (value == null) {
            return null;
        }
        Level level = Level.toLevel((String)value, (Level)Level.INFO);
        if (!AbstractLogHelper.isAllowed(level)) {
            throw new IllegalArgumentException(String.format("log level %s in property %s is not a supported value (allowed levels are %s)", level, propertyKey, Arrays.toString(ALLOWED_ROOT_LOG_LEVELS)));
        }
        return level;
    }

    static boolean isAllowed(Level level) {
        for (Level allowedRootLogLevel : ALLOWED_ROOT_LOG_LEVELS) {
            if (!level.equals(allowedRootLogLevel)) continue;
            return true;
        }
        return false;
    }
}

