/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.core.LayoutBase;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class LogbackJsonLayout
extends LayoutBase<ILoggingEvent> {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.US).withZone(ZoneId.systemDefault());
    private static final Pattern NEWLINE_REGEXP = Pattern.compile("\n");
    private final String processKey;

    public LogbackJsonLayout(String processKey) {
        this.processKey = Objects.requireNonNull(processKey);
    }

    String getProcessKey() {
        return this.processKey;
    }

    public String doLayout(ILoggingEvent event) {
        StringWriter output = new StringWriter();
        try (JsonWriter json = new JsonWriter((Writer)output);){
            json.beginObject();
            json.name("process").value(this.processKey);
            for (Map.Entry entry : event.getMDCPropertyMap().entrySet()) {
                if (entry.getValue() == null) continue;
                json.name((String)entry.getKey()).value((String)entry.getValue());
            }
            json.name("instant").value(event.getTimeStamp()).name("date").value(DATE_FORMATTER.format(Instant.ofEpochMilli(event.getTimeStamp()))).name("severity").value(event.getLevel().toString()).name("logger").value(event.getLoggerName()).name("message").value(NEWLINE_REGEXP.matcher(event.getFormattedMessage()).replaceAll("\r"));
            IThrowableProxy tp = event.getThrowableProxy();
            if (tp != null) {
                json.name("stacktrace").beginArray();
                int nbOfTabs = 0;
                while (tp != null) {
                    LogbackJsonLayout.printFirstLine(json, tp, nbOfTabs);
                    LogbackJsonLayout.render(json, tp, nbOfTabs);
                    tp = tp.getCause();
                    ++nbOfTabs;
                }
                json.endArray();
            }
            json.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("BUG - fail to create JSON", e);
        }
        output.write(System.lineSeparator());
        return output.toString();
    }

    private static void render(JsonWriter output, IThrowableProxy tp, int nbOfTabs) throws IOException {
        String tabs = StringUtils.repeat((String)"\t", (int)nbOfTabs);
        int commonFrames = tp.getCommonFrames();
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        for (int i = 0; i < stepArray.length - commonFrames; ++i) {
            StackTraceElementProxy step = stepArray[i];
            output.value(tabs + step.toString());
        }
        if (commonFrames > 0) {
            output.value(tabs + "... " + commonFrames + " common frames omitted");
        }
        for (IThrowableProxy suppressed : tp.getSuppressed()) {
            output.value(String.format("%sSuppressed: %s: %s", tabs, suppressed.getClassName(), suppressed.getMessage()));
            LogbackJsonLayout.render(output, suppressed, nbOfTabs + 1);
        }
    }

    private static void printFirstLine(JsonWriter output, IThrowableProxy tp, int nbOfTabs) throws IOException {
        String tabs = StringUtils.repeat((String)"\t", (int)nbOfTabs);
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            output.value(tabs + "Caused by: ");
        }
        output.value(tabs + tp.getClassName() + ": " + tp.getMessage());
    }
}

