/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.process.sharedmemoryfile;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sonar.process.sharedmemoryfile.ProcessCommands;

public class AllProcessesCommands
implements AutoCloseable {
    private static final int UP_BYTE_OFFSET = 0;
    private static final int HARD_STOP_BYTE_OFFSET = 1;
    private static final int STOP_BYTE_OFFSET = 2;
    private static final int RESTART_BYTE_OFFSET = 3;
    private static final int OPERATIONAL_BYTE_OFFSET = 4;
    private static final int PING_BYTE_OFFSET = 5;
    private static final int SYSTEM_INFO_URL_BYTE_OFFSET = 13;
    private static final int SYSTEM_INFO_URL_SIZE_IN_BYTES = 500;
    private static final int BYTE_LENGTH_FOR_ONE_PROCESS = 513;
    private static final int MAX_SHARED_MEMORY = 2565;
    private static final byte HARD_STOP = -1;
    private static final byte STOP = -46;
    private static final byte RESTART = -86;
    private static final byte OPERATIONAL = 89;
    private static final byte UP = 1;
    private static final byte EMPTY = 0;
    final MappedByteBuffer mappedByteBuffer;
    private final RandomAccessFile sharedMemory;

    public AllProcessesCommands(File directory) {
        if (!directory.isDirectory() || !directory.exists()) {
            throw new IllegalArgumentException("Not a valid directory: " + directory);
        }
        try {
            this.sharedMemory = new RandomAccessFile(new File(directory, "sharedmemory"), "rw");
            this.mappedByteBuffer = this.sharedMemory.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, 2565L);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to create shared memory : ", e);
        }
    }

    public void clean() {
        for (int i = 0; i < 5; ++i) {
            this.cleanData(i);
        }
    }

    public ProcessCommands create(int processNumber) {
        return this.createForProcess(processNumber, false);
    }

    public ProcessCommands createAfterClean(int processNumber) {
        return this.createForProcess(processNumber, true);
    }

    private ProcessCommands createForProcess(int processNumber, boolean clean) {
        this.checkProcessNumber(processNumber);
        ProcessCommandsImpl processCommands = new ProcessCommandsImpl(processNumber);
        if (clean) {
            this.cleanData(processNumber);
        }
        return processCommands;
    }

    boolean isUp(int processNumber) {
        return this.readByte(processNumber, 0) == 1;
    }

    void setUp(int processNumber) {
        this.writeByte(processNumber, 0, (byte)1);
    }

    boolean isOperational(int processNumber) {
        return this.readByte(processNumber, 4) == 89;
    }

    void setOperational(int processNumber) {
        this.writeByte(processNumber, 4, (byte)89);
    }

    void ping(int processNumber) {
        this.writeLong(processNumber, 5, System.currentTimeMillis());
    }

    long getLastPing(int processNumber) {
        return this.readLong(processNumber, 5);
    }

    String getSystemInfoUrl(int processNumber) {
        byte[] urlBytes = this.readBytes(processNumber, 13, 500);
        return new String(urlBytes, StandardCharsets.US_ASCII).trim();
    }

    void setSystemInfoUrl(int processNumber, String url) {
        byte[] urlBytes = StringUtils.rightPad((String)url, (int)500).getBytes(StandardCharsets.US_ASCII);
        if (urlBytes.length > 500) {
            throw new IllegalArgumentException(String.format("System Info URL is too long. Max is %d bytes. Got: %s", 500, url));
        }
        this.writeBytes(processNumber, 13, urlBytes);
    }

    void askForStop(int processNumber) {
        this.writeByte(processNumber, 2, (byte)-46);
    }

    boolean askedForStop(int processNumber) {
        return this.readByte(processNumber, 2) == -46;
    }

    void askForHardStop(int processNumber) {
        this.writeByte(processNumber, 1, (byte)-1);
    }

    boolean askedForHardStop(int processNumber) {
        return this.readByte(processNumber, 1) == -1;
    }

    void askForRestart(int processNumber) {
        this.writeByte(processNumber, 3, (byte)-86);
    }

    boolean askedForRestart(int processNumber) {
        return this.readByte(processNumber, 3) == -86;
    }

    void acknowledgeAskForRestart(int processNumber) {
        this.writeByte(processNumber, 3, (byte)0);
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.sharedMemory);
    }

    public void checkProcessNumber(int processNumber) {
        if (processNumber < 0 || processNumber >= 5) {
            throw new IllegalArgumentException(String.format("Process number %s is not valid", processNumber));
        }
    }

    private void cleanData(int processNumber) {
        for (int i = 0; i < 513; ++i) {
            this.writeByte(processNumber, i, (byte)0);
        }
    }

    private void writeByte(int processNumber, int offset, byte value) {
        this.mappedByteBuffer.put(this.offset(processNumber) + offset, value);
    }

    private void writeBytes(int processNumber, int offset, byte[] value) {
        int bufferOffset = this.offset(processNumber) + offset;
        for (int i = 0; i < value.length; ++i) {
            this.mappedByteBuffer.put(bufferOffset + i, value[i]);
        }
    }

    private byte readByte(int processNumber, int offset) {
        return this.mappedByteBuffer.get(this.offset(processNumber) + offset);
    }

    private byte[] readBytes(int processNumber, int offset, int length) {
        int bufferOffset = this.offset(processNumber) + offset;
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = this.mappedByteBuffer.get(bufferOffset + i);
        }
        return bytes;
    }

    private void writeLong(int processNumber, int offset, long value) {
        this.mappedByteBuffer.putLong(this.offset(processNumber) + offset, value);
    }

    private long readLong(int processNumber, int offset) {
        return this.mappedByteBuffer.getLong(this.offset(processNumber) + offset);
    }

    int offset(int processNumber) {
        return 513 * processNumber;
    }

    private class ProcessCommandsImpl
    implements ProcessCommands {
        private final int processNumber;

        public ProcessCommandsImpl(int processNumber) {
            this.processNumber = processNumber;
        }

        @Override
        public boolean isUp() {
            return AllProcessesCommands.this.isUp(this.processNumber);
        }

        @Override
        public void setUp() {
            AllProcessesCommands.this.setUp(this.processNumber);
        }

        @Override
        public boolean isOperational() {
            return AllProcessesCommands.this.isOperational(this.processNumber);
        }

        @Override
        public void setOperational() {
            AllProcessesCommands.this.setOperational(this.processNumber);
        }

        @Override
        public void ping() {
            AllProcessesCommands.this.ping(this.processNumber);
        }

        @Override
        public long getLastPing() {
            return AllProcessesCommands.this.getLastPing(this.processNumber);
        }

        @Override
        public void setHttpUrl(String s) {
            AllProcessesCommands.this.setSystemInfoUrl(this.processNumber, s);
        }

        @Override
        public String getHttpUrl() {
            return AllProcessesCommands.this.getSystemInfoUrl(this.processNumber);
        }

        @Override
        public void askForStop() {
            AllProcessesCommands.this.askForStop(this.processNumber);
        }

        @Override
        public boolean askedForStop() {
            return AllProcessesCommands.this.askedForStop(this.processNumber);
        }

        @Override
        public void askForHardStop() {
            AllProcessesCommands.this.askForHardStop(this.processNumber);
        }

        @Override
        public boolean askedForHardStop() {
            return AllProcessesCommands.this.askedForHardStop(this.processNumber);
        }

        @Override
        public void askForRestart() {
            AllProcessesCommands.this.askForRestart(this.processNumber);
        }

        @Override
        public boolean askedForRestart() {
            return AllProcessesCommands.this.askedForRestart(this.processNumber);
        }

        @Override
        public void acknowledgeAskForRestart() {
            AllProcessesCommands.this.acknowledgeAskForRestart(this.processNumber);
        }

        @Override
        public void endWatch() {
            throw new UnsupportedOperationException("ProcessCommands created from AllProcessesCommands can not be closed directly. Close AllProcessesCommands instead");
        }
    }
}

