/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.auth.saml;

import com.onelogin.saml2.Auth;
import com.onelogin.saml2.exception.SettingsException;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.settings.SettingsBuilder;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.sonar.api.server.ServerSide;
import org.sonar.api.server.authentication.Display;
import org.sonar.api.server.authentication.OAuth2IdentityProvider;
import org.sonar.api.server.authentication.UnauthorizedException;
import org.sonar.api.server.authentication.UserIdentity;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonarsource.auth.saml.SamlSettings;

@ServerSide
public class SamlIdentityProvider
implements OAuth2IdentityProvider {
    private static final Pattern HTTPS_PATTERN = Pattern.compile("https?://");
    private static final String KEY = "saml";
    private static final Logger LOGGER = Loggers.get(SamlIdentityProvider.class);
    private static final String ANY_URL = "http://anyurl";
    private static final String STATE_REQUEST_PARAMETER = "RelayState";
    private final SamlSettings samlSettings;

    public SamlIdentityProvider(SamlSettings samlSettings) {
        this.samlSettings = samlSettings;
    }

    public String getKey() {
        return KEY;
    }

    public String getName() {
        return this.samlSettings.getProviderName();
    }

    public Display getDisplay() {
        return Display.builder().setIconPath("/static/authsaml/saml.png").setBackgroundColor("#444444").build();
    }

    public boolean isEnabled() {
        return this.samlSettings.isEnabled();
    }

    public boolean allowsUsersToSignUp() {
        return true;
    }

    public void init(OAuth2IdentityProvider.InitContext context) {
        try {
            Auth auth = SamlIdentityProvider.newAuth(this.initSettings(context.getCallbackUrl()), context.getRequest(), context.getResponse());
            auth.login(context.generateCsrfState());
        }
        catch (SettingsException | IOException e) {
            throw new IllegalStateException("Fail to intialize SAML authentication plugin", e);
        }
    }

    public void callback(OAuth2IdentityProvider.CallbackContext context) {
        HttpServletRequest processedRequest = SamlIdentityProvider.useProxyHeadersInRequest(context.getRequest());
        Auth auth = SamlIdentityProvider.newAuth(this.initSettings(null), processedRequest, context.getResponse());
        SamlIdentityProvider.processResponse(auth);
        context.verifyCsrfState(STATE_REQUEST_PARAMETER);
        LOGGER.trace("Name ID : {}", (Object)auth.getNameId());
        SamlIdentityProvider.checkAuthentication(auth);
        LOGGER.trace("Attributes received : {}", auth.getAttributes());
        String login = SamlIdentityProvider.getNonNullFirstAttribute(auth, this.samlSettings.getUserLogin());
        UserIdentity.Builder userIdentityBuilder = UserIdentity.builder().setLogin(login).setProviderLogin(login).setName(SamlIdentityProvider.getNonNullFirstAttribute(auth, this.samlSettings.getUserName()));
        this.samlSettings.getUserEmail().ifPresent(email -> userIdentityBuilder.setEmail(SamlIdentityProvider.getFirstAttribute(auth, email)));
        this.samlSettings.getGroupName().ifPresent(group -> userIdentityBuilder.setGroups(SamlIdentityProvider.getGroups(auth, group)));
        context.authenticate(userIdentityBuilder.build());
        context.redirectToRequestedPage();
    }

    private static Auth newAuth(Saml2Settings saml2Settings, HttpServletRequest request, HttpServletResponse response) {
        try {
            return new Auth(saml2Settings, request, response);
        }
        catch (SettingsException e) {
            throw new IllegalStateException("Fail to create Auth", e);
        }
    }

    private static void processResponse(Auth auth) {
        try {
            auth.processResponse();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to process response", e);
        }
    }

    private static void checkAuthentication(Auth auth) {
        List<String> errors = auth.getErrors();
        if (auth.isAuthenticated() && errors.isEmpty()) {
            return;
        }
        String errorReason = auth.getLastErrorReason();
        throw new UnauthorizedException(errorReason != null && !errorReason.isEmpty() ? errorReason : "Unknown error reason");
    }

    private static String getNonNullFirstAttribute(Auth auth, String key) {
        String attribute = SamlIdentityProvider.getFirstAttribute(auth, key);
        Objects.requireNonNull(attribute, String.format("%s is missing", key));
        return attribute;
    }

    @CheckForNull
    private static String getFirstAttribute(Auth auth, String key) {
        Collection<String> attribute = auth.getAttribute(key);
        if (attribute == null || attribute.isEmpty()) {
            return null;
        }
        return attribute.iterator().next();
    }

    private static Set<String> getGroups(Auth auth, String groupAttribute) {
        Collection<String> attribute = auth.getAttribute(groupAttribute);
        if (attribute == null || attribute.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(attribute);
    }

    private Saml2Settings initSettings(@Nullable String callbackUrl) {
        HashMap<String, Object> samlData = new HashMap<String, Object>();
        samlData.put("onelogin.saml2.strict", true);
        samlData.put("onelogin.saml2.idp.entityid", this.samlSettings.getProviderId());
        samlData.put("onelogin.saml2.idp.single_sign_on_service.url", this.samlSettings.getLoginUrl());
        samlData.put("onelogin.saml2.idp.x509cert", this.samlSettings.getCertificate());
        samlData.put("onelogin.saml2.sp.entityid", this.samlSettings.getApplicationId());
        samlData.put("onelogin.saml2.sp.assertion_consumer_service.url", callbackUrl != null ? callbackUrl : ANY_URL);
        SettingsBuilder builder = new SettingsBuilder();
        return builder.fromValues(samlData).build();
    }

    private static HttpServletRequest useProxyHeadersInRequest(HttpServletRequest request) {
        final String forwardedScheme = request.getHeader("X-Forwarded-Proto");
        if (forwardedScheme != null) {
            request = new HttpServletRequestWrapper(request){

                @Override
                public String getScheme() {
                    return forwardedScheme;
                }

                @Override
                public StringBuffer getRequestURL() {
                    StringBuffer originalURL = ((HttpServletRequest)this.getRequest()).getRequestURL();
                    return new StringBuffer(HTTPS_PATTERN.matcher(originalURL.toString()).replaceFirst(forwardedScheme + "://"));
                }
            };
        }
        return request;
    }
}

