/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce;

import com.google.common.base.Preconditions;
import org.sonar.ce.ComputeEngine;
import org.sonar.ce.container.ComputeEngineContainer;
import org.sonar.ce.container.ComputeEngineStatus;
import org.sonar.process.Props;

public class ComputeEngineImpl
implements ComputeEngine,
ComputeEngineStatus {
    private final Props props;
    private final ComputeEngineContainer computeEngineContainer;
    private ComputeEngineStatus.Status status = ComputeEngineStatus.Status.INIT;

    public ComputeEngineImpl(Props props, ComputeEngineContainer computeEngineContainer) {
        this.props = props;
        this.computeEngineContainer = computeEngineContainer;
        computeEngineContainer.setComputeEngineStatus(this);
    }

    @Override
    public void startup() {
        Preconditions.checkState((this.status == ComputeEngineStatus.Status.INIT ? 1 : 0) != 0, (Object)"startup() can not be called multiple times");
        try {
            this.status = ComputeEngineStatus.Status.STARTING;
            this.computeEngineContainer.start(this.props);
        }
        finally {
            this.status = ComputeEngineStatus.Status.STARTED;
        }
    }

    @Override
    public void stopProcessing() {
        Preconditions.checkState((this.status.ordinal() >= ComputeEngineStatus.Status.STARTED.ordinal() ? 1 : 0) != 0, (Object)"stopProcessing() must not be called before startup()");
        Preconditions.checkState((this.status.ordinal() <= ComputeEngineStatus.Status.STOPPING.ordinal() ? 1 : 0) != 0, (Object)"stopProcessing() can not be called after shutdown()");
        Preconditions.checkState((this.status.ordinal() <= ComputeEngineStatus.Status.STOPPING_WORKERS.ordinal() ? 1 : 0) != 0, (Object)"stopProcessing() can not be called multiple times");
        try {
            this.status = ComputeEngineStatus.Status.STOPPING_WORKERS;
            this.computeEngineContainer.stopWorkers();
        }
        finally {
            this.status = ComputeEngineStatus.Status.WORKERS_STOPPED;
        }
    }

    @Override
    public void shutdown() {
        Preconditions.checkState((this.status.ordinal() >= ComputeEngineStatus.Status.STARTED.ordinal() ? 1 : 0) != 0, (Object)"shutdown() must not be called before startup()");
        Preconditions.checkState((this.status.ordinal() <= ComputeEngineStatus.Status.STOPPING.ordinal() ? 1 : 0) != 0, (Object)"shutdown() can not be called multiple times");
        try {
            this.status = ComputeEngineStatus.Status.STOPPING;
            this.computeEngineContainer.stop();
        }
        finally {
            this.status = ComputeEngineStatus.Status.STOPPED;
        }
    }

    @Override
    public ComputeEngineStatus.Status getStatus() {
        return this.status;
    }
}

