/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.app;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nullable;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.ce.ComputeEngine;
import org.sonar.ce.ComputeEngineImpl;
import org.sonar.ce.container.ComputeEngineContainerImpl;
import org.sonar.ce.logging.CeProcessLogging;
import org.sonar.process.MessageException;
import org.sonar.process.MinimumViableSystem;
import org.sonar.process.Monitored;
import org.sonar.process.ProcessEntryPoint;
import org.sonar.process.Props;

public class CeServer
implements Monitored {
    private static final Logger LOG = Loggers.get(CeServer.class);
    private static final String CE_MAIN_THREAD_NAME = "ce-main";
    private CountDownLatch awaitStop = new CountDownLatch(1);
    private final ComputeEngine computeEngine;
    @Nullable
    private CeMainThread ceMainThread = null;

    @VisibleForTesting
    protected CeServer(ComputeEngine computeEngine, MinimumViableSystem mvs) {
        this.computeEngine = computeEngine;
        mvs.checkWritableTempDir().checkRequiredJavaOptions((Map)ImmutableMap.of((Object)"file.encoding", (Object)"UTF-8"));
    }

    public void start() {
        Preconditions.checkState((this.ceMainThread == null ? 1 : 0) != 0, (Object)"start() can not be called twice");
        this.ceMainThread = new CeMainThread();
        this.ceMainThread.start();
    }

    public Monitored.Status getStatus() {
        Preconditions.checkState((this.ceMainThread != null ? 1 : 0) != 0, (Object)"getStatus() can not be called before start()");
        if (this.ceMainThread.isStarted()) {
            return this.ceMainThread.isOperational() ? Monitored.Status.OPERATIONAL : Monitored.Status.FAILED;
        }
        return Monitored.Status.DOWN;
    }

    public void awaitStop() {
        Preconditions.checkState((this.ceMainThread != null ? 1 : 0) != 0, (Object)"awaitStop() must not be called before start()");
        while (true) {
            try {
                this.awaitStop.await();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void stop() {
        if (this.ceMainThread != null) {
            this.ceMainThread.stopIt();
            this.awaitStop();
        }
    }

    public void hardStop() {
        if (this.ceMainThread != null) {
            this.ceMainThread.stopItNow();
            this.awaitStop();
        }
    }

    public static void main(String[] args) {
        ProcessEntryPoint entryPoint = ProcessEntryPoint.createForArguments((String[])args);
        Props props = entryPoint.getProps();
        new CeProcessLogging().configure(props);
        CeServer server = new CeServer(new ComputeEngineImpl(props, new ComputeEngineContainerImpl()), new MinimumViableSystem());
        entryPoint.launch((Monitored)server);
    }

    private class CeMainThread
    extends Thread {
        private final CountDownLatch stopSignal;
        private volatile boolean started;
        private volatile boolean operational;
        private volatile boolean hardStop;
        private volatile boolean dontInterrupt;

        public CeMainThread() {
            super(CeServer.CE_MAIN_THREAD_NAME);
            this.stopSignal = new CountDownLatch(1);
            this.started = false;
            this.operational = false;
            this.hardStop = false;
            this.dontInterrupt = false;
        }

        @Override
        public void run() {
            block5: {
                boolean startupSuccessful;
                this.operational = startupSuccessful = this.attemptStartup();
                this.started = true;
                try {
                    if (!startupSuccessful) break block5;
                    try {
                        this.stopSignal.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.attemptShutdown();
                }
                finally {
                    this.signalAwaitStop();
                }
            }
        }

        private boolean attemptStartup() {
            try {
                LOG.info("Compute Engine starting up...");
                CeServer.this.computeEngine.startup();
                LOG.info("Compute Engine is operational");
                return true;
            }
            catch (org.sonar.api.utils.MessageException | MessageException e) {
                LOG.error("Compute Engine startup failed: " + e.getMessage());
                return false;
            }
            catch (Throwable e) {
                LOG.error("Compute Engine startup failed", e);
                return false;
            }
        }

        private void attemptShutdown() {
            try {
                LOG.info("Compute Engine is stopping...");
                if (!this.hardStop) {
                    CeServer.this.computeEngine.stopProcessing();
                }
                this.dontInterrupt = true;
                CeMainThread.interrupted();
                CeServer.this.computeEngine.shutdown();
                LOG.info("Compute Engine is stopped");
            }
            catch (Throwable e) {
                LOG.error("Compute Engine failed to stop", e);
            }
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isOperational() {
            return this.operational;
        }

        public void stopIt() {
            this.stopSignal.countDown();
        }

        public void stopItNow() {
            this.hardStop = true;
            this.stopSignal.countDown();
            if (!this.dontInterrupt) {
                this.interrupt();
            }
        }

        private void signalAwaitStop() {
            CeServer.this.awaitStop.countDown();
        }
    }
}

