/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.container;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.picocontainer.Startable;
import org.sonar.api.Plugin;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.platform.PluginInfo;
import org.sonar.core.platform.PluginLoader;
import org.sonar.core.platform.PluginRepository;
import org.sonar.server.platform.ServerFileSystem;

public class CePluginRepository
implements PluginRepository,
Startable {
    private static final String[] JAR_FILE_EXTENSIONS = new String[]{"jar"};
    private static final String NOT_STARTED_YET = "not started yet";
    private final ServerFileSystem fs;
    private final PluginLoader loader;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final Map<String, PluginInfo> pluginInfosByKeys = new HashMap<String, PluginInfo>();
    private final Map<String, Plugin> pluginInstancesByKeys = new HashMap<String, Plugin>();

    public CePluginRepository(ServerFileSystem fs, PluginLoader loader) {
        this.fs = fs;
        this.loader = loader;
    }

    public void start() {
        Loggers.get(this.getClass()).info("Load plugins");
        for (File file : CePluginRepository.listJarFiles(this.fs.getInstalledPluginsDir())) {
            PluginInfo info = PluginInfo.create((File)file);
            this.pluginInfosByKeys.put(info.getKey(), info);
        }
        this.pluginInstancesByKeys.putAll(this.loader.load(this.pluginInfosByKeys));
        this.started.set(true);
    }

    public void stop() {
        this.loader.unload(this.pluginInstancesByKeys.values());
        this.pluginInstancesByKeys.clear();
        this.pluginInfosByKeys.clear();
        this.started.set(false);
    }

    public Collection<PluginInfo> getPluginInfos() {
        Preconditions.checkState((boolean)this.started.get(), (Object)NOT_STARTED_YET);
        return ImmutableList.copyOf(this.pluginInfosByKeys.values());
    }

    public PluginInfo getPluginInfo(String key) {
        Preconditions.checkState((boolean)this.started.get(), (Object)NOT_STARTED_YET);
        PluginInfo info = this.pluginInfosByKeys.get(key);
        if (info == null) {
            throw new IllegalArgumentException(String.format("Plugin [%s] does not exist", key));
        }
        return info;
    }

    public Plugin getPluginInstance(String key) {
        Preconditions.checkState((boolean)this.started.get(), (Object)NOT_STARTED_YET);
        Plugin plugin = this.pluginInstancesByKeys.get(key);
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (String)"Plugin [%s] does not exist", (Object[])new Object[]{key});
        return plugin;
    }

    public boolean hasPlugin(String key) {
        Preconditions.checkState((boolean)this.started.get(), (Object)NOT_STARTED_YET);
        return this.pluginInfosByKeys.containsKey(key);
    }

    private static Collection<File> listJarFiles(File dir) {
        if (dir.exists()) {
            return FileUtils.listFiles((File)dir, (String[])JAR_FILE_EXTENSIONS, (boolean)false);
        }
        return Collections.emptyList();
    }
}

