/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.monitoring;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.sonar.api.utils.System2;
import org.sonar.ce.monitoring.CEQueueStatus;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.ce.CeQueueDto;

public class CEQueueStatusImpl
implements CEQueueStatus {
    private final DbClient dbClient;
    private final System2 system;
    private final AtomicLong inProgress = new AtomicLong(0L);
    private final AtomicLong error = new AtomicLong(0L);
    private final AtomicLong success = new AtomicLong(0L);
    private final AtomicLong processingTime = new AtomicLong(0L);

    public CEQueueStatusImpl(DbClient dbClient, System2 system) {
        this.dbClient = dbClient;
        this.system = system;
    }

    @Override
    public long addInProgress() {
        return this.inProgress.incrementAndGet();
    }

    @Override
    public long addError(long processingTimeInMs) {
        this.addProcessingTime(processingTimeInMs);
        this.inProgress.decrementAndGet();
        return this.error.incrementAndGet();
    }

    @Override
    public long addSuccess(long processingTimeInMs) {
        this.addProcessingTime(processingTimeInMs);
        this.inProgress.decrementAndGet();
        return this.success.incrementAndGet();
    }

    private void addProcessingTime(long ms) {
        Preconditions.checkArgument((ms >= 0L ? 1 : 0) != 0, (Object)"Processing time can not be < 0");
        this.processingTime.addAndGet(ms);
    }

    @Override
    public long getPendingCount() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            long l = this.dbClient.ceQueueDao().countByStatus(dbSession, CeQueueDto.Status.PENDING);
            return l;
        }
    }

    @Override
    public Optional<Long> getLongestTimePending() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional<Long> optional = this.dbClient.ceQueueDao().selectCreationDateOfOldestPendingByMainComponentUuid(dbSession, null).map(creationDate -> this.system.now() - creationDate);
            return optional;
        }
    }

    @Override
    public boolean areWorkersPaused() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional val = this.dbClient.internalPropertiesDao().selectByKey(dbSession, "ce.pause");
            boolean bl = "true".equals(val.orElse(null));
            return bl;
        }
    }

    @Override
    public long getInProgressCount() {
        return this.inProgress.get();
    }

    @Override
    public long getErrorCount() {
        return this.error.get();
    }

    @Override
    public long getSuccessCount() {
        return this.success.get();
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime.get();
    }
}

