/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.ce.notification;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Collections;
import javax.annotation.Nullable;
import org.sonar.api.notifications.Notification;
import org.sonar.api.utils.System2;
import org.sonar.ce.task.CeTask;
import org.sonar.ce.task.CeTaskResult;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotification;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotificationBuilder;
import org.sonar.ce.task.projectanalysis.notification.ReportAnalysisFailureNotificationSerializer;
import org.sonar.ce.taskprocessor.CeWorker;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.RowNotFoundException;
import org.sonar.db.ce.CeActivityDto;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.notification.NotificationService;

public class ReportAnalysisFailureNotificationExecutionListener
implements CeWorker.ExecutionListener {
    private final NotificationService notificationService;
    private final DbClient dbClient;
    private final ReportAnalysisFailureNotificationSerializer taskFailureNotificationSerializer;
    private final System2 system2;

    public ReportAnalysisFailureNotificationExecutionListener(NotificationService notificationService, DbClient dbClient, ReportAnalysisFailureNotificationSerializer taskFailureNotificationSerializer, System2 system2) {
        this.notificationService = notificationService;
        this.dbClient = dbClient;
        this.taskFailureNotificationSerializer = taskFailureNotificationSerializer;
        this.system2 = system2;
    }

    @Override
    public void onStart(CeTask ceTask) {
    }

    @Override
    public void onEnd(CeTask ceTask, CeActivityDto.Status status, Duration duration, @Nullable CeTaskResult taskResult, @Nullable Throwable error) {
        if (status == CeActivityDto.Status.SUCCESS) {
            return;
        }
        String projectUuid = ceTask.getComponent().map(CeTask.Component::getUuid).orElse(null);
        if (!"REPORT".equals(ceTask.getType()) || projectUuid == null) {
            return;
        }
        if (this.notificationService.hasProjectSubscribersForTypes(projectUuid, Collections.singleton(ReportAnalysisFailureNotification.class))) {
            try (DbSession dbSession = this.dbClient.openSession(false);){
                ComponentDto projectDto = this.dbClient.componentDao().selectOrFailByUuid(dbSession, projectUuid);
                ReportAnalysisFailureNotificationExecutionListener.checkScopeAndQualifier(projectDto);
                CeActivityDto ceActivityDto = (CeActivityDto)this.dbClient.ceActivityDao().selectByUuid(dbSession, ceTask.getUuid()).orElseThrow(() -> new RowNotFoundException(String.format("CeActivity with uuid '%s' not found", ceTask.getUuid())));
                ReportAnalysisFailureNotificationBuilder taskFailureNotification = this.buildNotification(ceActivityDto, projectDto, error);
                ReportAnalysisFailureNotification notification = this.taskFailureNotificationSerializer.toNotification(taskFailureNotification);
                this.notificationService.deliverEmails(Collections.singleton(notification));
                this.notificationService.deliver((Notification)notification);
            }
        }
    }

    private static void checkScopeAndQualifier(ComponentDto projectDto) {
        String scope = projectDto.scope();
        String qualifier = projectDto.qualifier();
        Preconditions.checkArgument((scope.equals("PRJ") && qualifier.equals("TRK") ? 1 : 0) != 0, (String)"Component %s must be a project (scope=%s, qualifier=%s)", (Object[])new Object[]{projectDto.uuid(), scope, qualifier});
    }

    private ReportAnalysisFailureNotificationBuilder buildNotification(CeActivityDto ceActivityDto, ComponentDto projectDto, @Nullable Throwable error) {
        Long executedAt = ceActivityDto.getExecutedAt();
        return new ReportAnalysisFailureNotificationBuilder(new ReportAnalysisFailureNotificationBuilder.Project(projectDto.uuid(), projectDto.getKey(), projectDto.name(), projectDto.getBranch()), new ReportAnalysisFailureNotificationBuilder.Task(ceActivityDto.getUuid(), ceActivityDto.getSubmittedAt(), executedAt == null ? this.system2.now() : executedAt.longValue()), error == null ? null : error.getMessage());
    }
}

