/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.highlighting.NewHighlighting;
import org.sonar.api.batch.sensor.highlighting.TypeOfText;
import org.sonar.python.PythonCheck;
import org.sonar.python.PythonVisitor;
import org.sonar.python.TokenLocation;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonTokenType;

public class PythonHighlighter
extends PythonVisitor {
    private NewHighlighting newHighlighting;
    private Set<Token> docStringTokens = new HashSet<Token>();

    public PythonHighlighter(SensorContext context, InputFile inputFile) {
        this.newHighlighting = context.newHighlighting();
        this.newHighlighting.onFile(inputFile);
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return PythonCheck.immutableSet(PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF, PythonGrammar.FILE_INPUT);
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(PythonGrammar.FILE_INPUT)) {
            this.checkFirstStatement(astNode.getFirstChild(PythonGrammar.STATEMENT));
        } else {
            this.checkFirstStatement(astNode.getFirstChild(PythonGrammar.SUITE).getFirstChild(PythonGrammar.STATEMENT));
        }
    }

    private void checkFirstStatement(@Nullable AstNode firstStatement) {
        List<Token> tokens;
        if (firstStatement != null && (tokens = firstStatement.getTokens()).size() == 2 && tokens.get(0).getType().equals(PythonTokenType.STRING)) {
            this.highlight(tokens.get(0), TypeOfText.STRUCTURED_COMMENT);
            this.docStringTokens.add(tokens.get(0));
        }
    }

    @Override
    public void visitToken(Token token) {
        if (token.getType().equals(PythonTokenType.NUMBER)) {
            this.highlight(token, TypeOfText.CONSTANT);
        } else if (token.getType() instanceof PythonKeyword) {
            this.highlight(token, TypeOfText.KEYWORD);
        } else if (token.getType().equals(PythonTokenType.STRING) && !this.docStringTokens.contains(token)) {
            this.highlight(token, TypeOfText.STRING);
        } else if (token.getType().equals(GenericTokenType.IDENTIFIER) && PythonHighlighter.isPython3Keyword(token.getValue())) {
            this.highlight(token, TypeOfText.KEYWORD);
        }
        for (Trivia trivia : token.getTrivia()) {
            this.highlight(trivia.getToken(), TypeOfText.COMMENT);
        }
    }

    private static boolean isPython3Keyword(String value) {
        return "await".equals(value) || "async".equals(value);
    }

    @Override
    public void leaveFile(@Nullable AstNode astNode) {
        this.newHighlighting.save();
    }

    private void highlight(Token token, TypeOfText typeOfText) {
        TokenLocation tokenLocation = new TokenLocation(token);
        this.newHighlighting.highlight(tokenLocation.startLine(), tokenLocation.startLineOffset(), tokenLocation.endLine(), tokenLocation.endLineOffset(), typeOfText);
    }
}

